/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CompileTimeConstant;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnsignedErrorValueTypeConstant
implements CompileTimeConstant<Unit> {
    @NotNull
    private final Number value;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final CompileTimeConstant.Parameters parameters;
    @NotNull
    private final ErrorValue.ErrorValueWithMessage errorValue;

    public UnsignedErrorValueTypeConstant(@NotNull Number value, @NotNull ModuleDescriptor moduleDescriptor, @NotNull CompileTimeConstant.Parameters parameters) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.value = value;
        this.moduleDescriptor = moduleDescriptor;
        this.parameters = parameters;
        this.errorValue = new ErrorValue.ErrorValueWithMessage("Type cannot be resolved. Please make sure you have the required dependencies for unsigned types in the classpath");
    }

    @Override
    @NotNull
    public ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @Override
    @NotNull
    public CompileTimeConstant.Parameters getParameters() {
        return this.parameters;
    }

    @NotNull
    public final ErrorValue.ErrorValueWithMessage getErrorValue() {
        return this.errorValue;
    }

    @Override
    @NotNull
    public ConstantValue<Unit> toConstantValue(@NotNull KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        return this.errorValue;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof UnsignedErrorValueTypeConstant && Intrinsics.areEqual((Object)this.value, (Object)((UnsignedErrorValueTypeConstant)other).value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean getHasIntegerLiteralType() {
        return false;
    }

    @Override
    public boolean isError() {
        return CompileTimeConstant.DefaultImpls.isError(this);
    }

    @Override
    public void getValue(@NotNull KotlinType expectedType) {
        CompileTimeConstant.DefaultImpls.getValue(this, expectedType);
    }

    @Override
    public boolean getCanBeUsedInAnnotations() {
        return CompileTimeConstant.DefaultImpls.getCanBeUsedInAnnotations(this);
    }

    @Override
    public boolean getUsesVariableAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesVariableAsConstant(this);
    }

    @Override
    public boolean getUsesNonConstValAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesNonConstValAsConstant(this);
    }

    @Override
    public boolean isPure() {
        return CompileTimeConstant.DefaultImpls.isPure(this);
    }

    @Override
    public boolean isUnsignedNumberLiteral() {
        return CompileTimeConstant.DefaultImpls.isUnsignedNumberLiteral(this);
    }
}

