/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedTypes;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CompileTimeConstantKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class PrimitiveTypeUtilKt {
    public static final long minValue(@NotNull KotlinType $this$minValue) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$minValue, (String)"<this>");
        if (UnsignedTypes.isUnsignedType($this$minValue)) {
            return 0L;
        }
        if (KotlinBuiltIns.isByte($this$minValue)) {
            l = -128L;
        } else if (KotlinBuiltIns.isShort($this$minValue)) {
            l = -32768L;
        } else if (KotlinBuiltIns.isInt($this$minValue)) {
            l = Integer.MIN_VALUE;
        } else {
            throw new IllegalStateException(("Can't get min value for type: " + $this$minValue).toString());
        }
        return l;
    }

    public static final long maxValue(@NotNull KotlinType $this$maxValue) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$maxValue, (String)"<this>");
        if (KotlinBuiltIns.isByte($this$maxValue)) {
            l = 127L;
        } else if (KotlinBuiltIns.isShort($this$maxValue)) {
            l = 32767L;
        } else if (KotlinBuiltIns.isInt($this$maxValue)) {
            l = Integer.MAX_VALUE;
        } else if (KotlinBuiltIns.isUByte($this$maxValue)) {
            l = (long)-1 & 0xFFL;
        } else if (KotlinBuiltIns.isUShort($this$maxValue)) {
            l = (long)-1 & 0xFFFFL;
        } else if (KotlinBuiltIns.isUInt($this$maxValue)) {
            l = (long)-1 & 0xFFFFFFFFL;
        } else {
            throw new IllegalStateException(("Can't get max value for type: " + $this$maxValue).toString());
        }
        return l;
    }

    @NotNull
    public static final SimpleType unsignedType(@NotNull ModuleDescriptor $this$unsignedType, @NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)$this$unsignedType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies($this$unsignedType, classId);
        Intrinsics.checkNotNull((Object)classDescriptor);
        SimpleType simpleType = classDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        return simpleType;
    }

    @NotNull
    public static final SimpleType getUIntType(@NotNull ModuleDescriptor $this$uIntType) {
        Intrinsics.checkNotNullParameter((Object)$this$uIntType, (String)"<this>");
        return PrimitiveTypeUtilKt.unsignedType($this$uIntType, StandardNames.FqNames.uInt);
    }

    @NotNull
    public static final SimpleType getULongType(@NotNull ModuleDescriptor $this$uLongType) {
        Intrinsics.checkNotNullParameter((Object)$this$uLongType, (String)"<this>");
        return PrimitiveTypeUtilKt.unsignedType($this$uLongType, StandardNames.FqNames.uLong);
    }

    @NotNull
    public static final SimpleType getUByteType(@NotNull ModuleDescriptor $this$uByteType) {
        Intrinsics.checkNotNullParameter((Object)$this$uByteType, (String)"<this>");
        return PrimitiveTypeUtilKt.unsignedType($this$uByteType, StandardNames.FqNames.uByte);
    }

    @NotNull
    public static final SimpleType getUShortType(@NotNull ModuleDescriptor $this$uShortType) {
        Intrinsics.checkNotNullParameter((Object)$this$uShortType, (String)"<this>");
        return PrimitiveTypeUtilKt.unsignedType($this$uShortType, StandardNames.FqNames.uShort);
    }

    @NotNull
    public static final Collection<KotlinType> getAllSignedLiteralTypes(@NotNull ModuleDescriptor $this$allSignedLiteralTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$allSignedLiteralTypes, (String)"<this>");
        Object[] objectArray = new SimpleType[]{$this$allSignedLiteralTypes.getBuiltIns().getIntType(), $this$allSignedLiteralTypes.getBuiltIns().getLongType(), $this$allSignedLiteralTypes.getBuiltIns().getByteType(), $this$allSignedLiteralTypes.getBuiltIns().getShortType()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public static final Collection<KotlinType> getAllUnsignedLiteralTypes(@NotNull ModuleDescriptor $this$allUnsignedLiteralTypes) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)$this$allUnsignedLiteralTypes, (String)"<this>");
        if (CompileTimeConstantKt.hasUnsignedTypesInModuleDependencies($this$allUnsignedLiteralTypes)) {
            Object[] objectArray = new SimpleType[]{PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, StandardNames.FqNames.uInt), PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, StandardNames.FqNames.uLong), PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, StandardNames.FqNames.uByte), PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, StandardNames.FqNames.uShort)};
            collection = CollectionsKt.listOf((Object[])objectArray);
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }
}

