/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CompileTimeConstant;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CompileTimeConstantKt;
import kotlin.reflect.jvm.internal.impl.resolve.constants.PrimitiveTypeUtilKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeRefinement;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntegerValueTypeConstructor
implements TypeConstructor {
    private final long value;
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final ArrayList<KotlinType> supertypes;

    public IntegerValueTypeConstructor(long value, @NotNull ModuleDescriptor module, @NotNull CompileTimeConstant.Parameters parameters) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.value = value;
        this.module = module;
        this.supertypes = new ArrayList(4);
        boolean isUnsigned = parameters.isUnsignedNumberLiteral();
        boolean isConvertable = parameters.isConvertableConstVal();
        if (isUnsigned || isConvertable) {
            boolean bl = CompileTimeConstantKt.hasUnsignedTypesInModuleDependencies(this.module);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Unsigned types should be on classpath to create an unsigned type constructor";
                throw new AssertionError((Object)string);
            }
        }
        if (isConvertable) {
            this.addSignedSuperTypes();
            this.addUnsignedSuperTypes();
        } else if (isUnsigned) {
            this.addUnsignedSuperTypes();
        } else {
            this.addSignedSuperTypes();
        }
    }

    private final void addSignedSuperTypes() {
        SimpleType simpleType = this.getBuiltIns().getIntType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getIntType(...)");
        this.checkBoundsAndAddSuperType(this.value, simpleType);
        SimpleType simpleType2 = this.getBuiltIns().getByteType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getByteType(...)");
        this.checkBoundsAndAddSuperType(this.value, simpleType2);
        SimpleType simpleType3 = this.getBuiltIns().getShortType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"getShortType(...)");
        this.checkBoundsAndAddSuperType(this.value, simpleType3);
        this.supertypes.add(this.getBuiltIns().getLongType());
    }

    private final void addUnsignedSuperTypes() {
        this.checkBoundsAndAddSuperType(this.value, PrimitiveTypeUtilKt.unsignedType(this.module, StandardNames.FqNames.uInt));
        this.checkBoundsAndAddSuperType(this.value, PrimitiveTypeUtilKt.unsignedType(this.module, StandardNames.FqNames.uByte));
        this.checkBoundsAndAddSuperType(this.value, PrimitiveTypeUtilKt.unsignedType(this.module, StandardNames.FqNames.uShort));
        this.supertypes.add(PrimitiveTypeUtilKt.unsignedType(this.module, StandardNames.FqNames.uLong));
    }

    private final void checkBoundsAndAddSuperType(long value, KotlinType kotlinType) {
        long l = PrimitiveTypeUtilKt.minValue(kotlinType);
        boolean bl = value <= PrimitiveTypeUtilKt.maxValue(kotlinType) ? l <= value : false;
        if (bl) {
            this.supertypes.add(kotlinType);
        }
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        return this.supertypes;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Nullable
    public Void getDeclarationDescriptor() {
        return null;
    }

    public final long getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    @Override
    @TypeRefinement
    @NotNull
    public TypeConstructor refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        return this;
    }

    @NotNull
    public String toString() {
        return "IntegerValueType(" + this.value + ')';
    }
}

