/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CompileTimeConstant;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CompileTimeConstantKt;
import kotlin.reflect.jvm.internal.impl.resolve.constants.PrimitiveTypeUtilKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeRefinement;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nIntegerLiteralTypeConstructor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntegerLiteralTypeConstructor.kt\norg/jetbrains/kotlin/resolve/constants/IntegerLiteralTypeConstructor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1740#2,3:182\n1761#2,3:185\n*S KotlinDebug\n*F\n+ 1 IntegerLiteralTypeConstructor.kt\norg/jetbrains/kotlin/resolve/constants/IntegerLiteralTypeConstructor\n*L\n132#1:182,3\n176#1:185,3\n*E\n"})
public final class IntegerLiteralTypeConstructor
implements TypeConstructor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long value;
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final Set<KotlinType> possibleTypes;
    @NotNull
    private final SimpleType type;
    @NotNull
    private final Lazy supertypes$delegate;

    @NotNull
    public final Set<KotlinType> getPossibleTypes() {
        return this.possibleTypes;
    }

    public IntegerLiteralTypeConstructor(long value, @NotNull ModuleDescriptor module, @NotNull CompileTimeConstant.Parameters parameters) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.type = KotlinTypeFactory.integerLiteralType(TypeAttributes.Companion.getEmpty(), this, false);
        this.supertypes$delegate = LazyKt.lazy(() -> IntegerLiteralTypeConstructor.supertypes_delegate$lambda$2(this));
        this.value = value;
        this.module = module;
        Set possibleTypes = new LinkedHashSet();
        boolean isUnsigned = parameters.isUnsignedNumberLiteral();
        boolean isConvertable = parameters.isConvertableConstVal();
        if (isUnsigned || isConvertable) {
            boolean bl = CompileTimeConstantKt.hasUnsignedTypesInModuleDependencies(module);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Unsigned types should be on classpath to create an unsigned type constructor";
                throw new AssertionError((Object)string);
            }
        }
        if (isConvertable) {
            IntegerLiteralTypeConstructor._init_$addSignedPossibleTypes(value, this, possibleTypes);
            IntegerLiteralTypeConstructor._init_$addUnsignedPossibleTypes(value, module, possibleTypes);
        } else if (isUnsigned) {
            IntegerLiteralTypeConstructor._init_$addUnsignedPossibleTypes(value, module, possibleTypes);
        } else {
            IntegerLiteralTypeConstructor._init_$addSignedPossibleTypes(value, this, possibleTypes);
        }
        this.possibleTypes = possibleTypes;
    }

    private IntegerLiteralTypeConstructor(long value, ModuleDescriptor module, Set<? extends KotlinType> possibleTypes) {
        this.type = KotlinTypeFactory.integerLiteralType(TypeAttributes.Companion.getEmpty(), this, false);
        this.supertypes$delegate = LazyKt.lazy(() -> IntegerLiteralTypeConstructor.supertypes_delegate$lambda$2(this));
        this.value = value;
        this.module = module;
        this.possibleTypes = possibleTypes;
    }

    private final boolean isContainsOnlyUnsignedTypes() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = PrimitiveTypeUtilKt.getAllSignedLiteralTypes(this.module);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!this.possibleTypes.contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final List<KotlinType> getSupertypes() {
        Lazy lazy = this.supertypes$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final KotlinType getApproximatedType() {
        KotlinType kotlinType;
        if (this.possibleTypes.contains(this.getBuiltIns().getIntType())) {
            SimpleType simpleType = this.getBuiltIns().getIntType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getIntType(...)");
            kotlinType = simpleType;
        } else if (this.possibleTypes.contains(this.getBuiltIns().getLongType())) {
            SimpleType simpleType = this.getBuiltIns().getLongType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getLongType(...)");
            kotlinType = simpleType;
        } else if (this.possibleTypes.contains(this.getBuiltIns().getByteType())) {
            SimpleType simpleType = this.getBuiltIns().getByteType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getByteType(...)");
            kotlinType = simpleType;
        } else if (this.possibleTypes.contains(this.getBuiltIns().getShortType())) {
            SimpleType simpleType = this.getBuiltIns().getShortType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getShortType(...)");
            kotlinType = simpleType;
        } else if (this.possibleTypes.contains(PrimitiveTypeUtilKt.getUIntType(this.module))) {
            kotlinType = PrimitiveTypeUtilKt.getUIntType(this.module);
        } else if (this.possibleTypes.contains(PrimitiveTypeUtilKt.getULongType(this.module))) {
            kotlinType = PrimitiveTypeUtilKt.getULongType(this.module);
        } else if (this.possibleTypes.contains(PrimitiveTypeUtilKt.getUByteType(this.module))) {
            kotlinType = PrimitiveTypeUtilKt.getUByteType(this.module);
        } else if (this.possibleTypes.contains(PrimitiveTypeUtilKt.getUShortType(this.module))) {
            kotlinType = PrimitiveTypeUtilKt.getUShortType(this.module);
        } else {
            throw new IllegalStateException();
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        return this.getSupertypes();
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getDeclarationDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    @Override
    @TypeRefinement
    @NotNull
    public TypeConstructor refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        return this;
    }

    @NotNull
    public String toString() {
        return "IntegerLiteralType" + this.valueToString();
    }

    public final boolean checkConstructor(@NotNull TypeConstructor constructor) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            Iterable $this$any$iv = this.possibleTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getConstructor(), (Object)constructor)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String valueToString() {
        return '[' + CollectionsKt.joinToString$default((Iterable)this.possibleTypes, (CharSequence)",", null, null, (int)0, null, IntegerLiteralTypeConstructor::valueToString$lambda$4, (int)30, null) + ']';
    }

    private static final void _init_$checkBoundsAndAddPossibleType(Set<KotlinType> possibleTypes, long value, KotlinType kotlinType) {
        long l = PrimitiveTypeUtilKt.minValue(kotlinType);
        boolean bl = value <= PrimitiveTypeUtilKt.maxValue(kotlinType) ? l <= value : false;
        if (bl) {
            possibleTypes.add(kotlinType);
        }
    }

    private static final void _init_$addSignedPossibleTypes(long $value, IntegerLiteralTypeConstructor this$0, Set<KotlinType> possibleTypes) {
        SimpleType simpleType = this$0.getBuiltIns().getIntType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getIntType(...)");
        IntegerLiteralTypeConstructor._init_$checkBoundsAndAddPossibleType(possibleTypes, $value, simpleType);
        SimpleType simpleType2 = this$0.getBuiltIns().getLongType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getLongType(...)");
        possibleTypes.add(simpleType2);
        SimpleType simpleType3 = this$0.getBuiltIns().getByteType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"getByteType(...)");
        IntegerLiteralTypeConstructor._init_$checkBoundsAndAddPossibleType(possibleTypes, $value, simpleType3);
        SimpleType simpleType4 = this$0.getBuiltIns().getShortType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType4, (String)"getShortType(...)");
        IntegerLiteralTypeConstructor._init_$checkBoundsAndAddPossibleType(possibleTypes, $value, simpleType4);
    }

    private static final void _init_$addUnsignedPossibleTypes(long $value, ModuleDescriptor $module, Set<KotlinType> possibleTypes) {
        IntegerLiteralTypeConstructor._init_$checkBoundsAndAddPossibleType(possibleTypes, $value, PrimitiveTypeUtilKt.getUIntType($module));
        possibleTypes.add(PrimitiveTypeUtilKt.getULongType($module));
        IntegerLiteralTypeConstructor._init_$checkBoundsAndAddPossibleType(possibleTypes, $value, PrimitiveTypeUtilKt.getUByteType($module));
        IntegerLiteralTypeConstructor._init_$checkBoundsAndAddPossibleType(possibleTypes, $value, PrimitiveTypeUtilKt.getUShortType($module));
    }

    private static final List supertypes_delegate$lambda$2(IntegerLiteralTypeConstructor this$0) {
        Object[] objectArray = new SimpleType[1];
        SimpleType simpleType = this$0.getBuiltIns().getComparable().getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        objectArray[0] = TypeSubstitutionKt.replace$default(simpleType, CollectionsKt.listOf((Object)new TypeProjectionImpl(Variance.IN_VARIANCE, this$0.type)), null, 2, null);
        List result = CollectionsKt.mutableListOf((Object[])objectArray);
        if (!this$0.isContainsOnlyUnsignedTypes()) {
            ((Collection)result).add(this$0.getBuiltIns().getNumberType());
        }
        return result;
    }

    private static final CharSequence valueToString$lambda$4(KotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    public /* synthetic */ IntegerLiteralTypeConstructor(long value, ModuleDescriptor module, Set possibleTypes, DefaultConstructorMarker $constructor_marker) {
        this(value, module, possibleTypes);
    }

    @SourceDebugExtension(value={"SMAP\nIntegerLiteralTypeConstructor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntegerLiteralTypeConstructor.kt\norg/jetbrains/kotlin/resolve/constants/IntegerLiteralTypeConstructor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n2783#2,7:182\n*S KotlinDebug\n*F\n+ 1 IntegerLiteralTypeConstructor.kt\norg/jetbrains/kotlin/resolve/constants/IntegerLiteralTypeConstructor$Companion\n*L\n40#1:182,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SimpleType findCommonSuperType(@NotNull Collection<? extends SimpleType> types) {
            Intrinsics.checkNotNullParameter(types, (String)"types");
            return this.findCommonSuperTypeOrIntersectionType(types, Mode.COMMON_SUPER_TYPE);
        }

        @Nullable
        public final SimpleType findIntersectionType(@NotNull Collection<? extends SimpleType> types) {
            Intrinsics.checkNotNullParameter(types, (String)"types");
            return this.findCommonSuperTypeOrIntersectionType(types, Mode.INTERSECTION_TYPE);
        }

        /*
         * WARNING - void declaration
         */
        private final SimpleType findCommonSuperTypeOrIntersectionType(Collection<? extends SimpleType> types, Mode mode) {
            if (types.isEmpty()) {
                return null;
            }
            Iterable $this$reduce$iv = types;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void right;
                SimpleType simpleType = (SimpleType)iterator$iv.next();
                SimpleType left = (SimpleType)accumulator$iv;
                boolean bl = false;
                accumulator$iv = Companion.fold(left, (SimpleType)right, mode);
            }
            return (SimpleType)accumulator$iv;
        }

        private final SimpleType fold(SimpleType left, SimpleType right, Mode mode) {
            if (left == null || right == null) {
                return null;
            }
            TypeConstructor leftConstructor = left.getConstructor();
            TypeConstructor rightConstructor = right.getConstructor();
            return leftConstructor instanceof IntegerLiteralTypeConstructor && rightConstructor instanceof IntegerLiteralTypeConstructor ? this.fold((IntegerLiteralTypeConstructor)leftConstructor, (IntegerLiteralTypeConstructor)rightConstructor, mode) : (leftConstructor instanceof IntegerLiteralTypeConstructor ? this.fold((IntegerLiteralTypeConstructor)leftConstructor, right) : (rightConstructor instanceof IntegerLiteralTypeConstructor ? this.fold((IntegerLiteralTypeConstructor)rightConstructor, left) : null));
        }

        private final SimpleType fold(IntegerLiteralTypeConstructor left, IntegerLiteralTypeConstructor right, Mode mode) {
            Set set;
            switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                case 1: {
                    set = CollectionsKt.intersect((Iterable)left.getPossibleTypes(), (Iterable)right.getPossibleTypes());
                    break;
                }
                case 2: {
                    set = CollectionsKt.union((Iterable)left.getPossibleTypes(), (Iterable)right.getPossibleTypes());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Set possibleTypes = set;
            IntegerLiteralTypeConstructor constructor = new IntegerLiteralTypeConstructor(left.value, left.module, possibleTypes, null);
            return KotlinTypeFactory.integerLiteralType(TypeAttributes.Companion.getEmpty(), constructor, false);
        }

        private final SimpleType fold(IntegerLiteralTypeConstructor left, SimpleType right) {
            return left.getPossibleTypes().contains(right) ? right : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static final class Mode
        extends Enum<Mode> {
            public static final /* enum */ Mode COMMON_SUPER_TYPE = new Mode();
            public static final /* enum */ Mode INTERSECTION_TYPE = new Mode();
            private static final /* synthetic */ Mode[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Mode[] values() {
                return (Mode[])$VALUES.clone();
            }

            public static Mode valueOf(String value) {
                return Enum.valueOf(Mode.class, value);
            }

            @NotNull
            public static EnumEntries<Mode> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = modeArray = new Mode[]{Mode.COMMON_SUPER_TYPE, Mode.INTERSECTION_TYPE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Mode.values().length];
                try {
                    nArray[Mode.COMMON_SUPER_TYPE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.INTERSECTION_TYPE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

