/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.BooleanValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CharValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactoryKt;
import kotlin.reflect.jvm.internal.impl.resolve.constants.DoubleValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.FloatValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.NullValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.TypedArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UnsignedValueConstant;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nConstantValueFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantValueFactory.kt\norg/jetbrains/kotlin/resolve/constants/ConstantValueFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1617#2,9:104\n1869#2:113\n1870#2:115\n1626#2:116\n1#3:114\n*S KotlinDebug\n*F\n+ 1 ConstantValueFactory.kt\norg/jetbrains/kotlin/resolve/constants/ConstantValueFactory\n*L\n64#1:104,9\n64#1:113\n64#1:115\n64#1:116\n64#1:114\n*E\n"})
public final class ConstantValueFactory {
    @NotNull
    public static final ConstantValueFactory INSTANCE = new ConstantValueFactory();

    private ConstantValueFactory() {
    }

    @NotNull
    public final ArrayValue createArrayValue(@NotNull List<? extends ConstantValue<?>> value, @NotNull KotlinType type) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new TypedArrayValue(value, type);
    }

    @Nullable
    public final ConstantValue<?> createConstantValue(@Nullable Object value, @Nullable ModuleDescriptor module) {
        Object object = value;
        return object instanceof Byte ? (ConstantValue)new ByteValue(((Number)value).byteValue()) : (object instanceof Short ? (ConstantValue)new ShortValue(((Number)value).shortValue()) : (object instanceof Integer ? (ConstantValue)new IntValue(((Number)value).intValue()) : (object instanceof Long ? (ConstantValue)new LongValue(((Number)value).longValue()) : (object instanceof Character ? (ConstantValue)new CharValue(((Character)value).charValue()) : (object instanceof Float ? (ConstantValue)new FloatValue(((Number)value).floatValue()) : (object instanceof Double ? (ConstantValue)new DoubleValue(((Number)value).doubleValue()) : (object instanceof Boolean ? (ConstantValue)new BooleanValue((Boolean)value) : (object instanceof String ? (ConstantValue)new StringValue((String)value) : (object instanceof byte[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((byte[])((byte[])value)), module, PrimitiveType.BYTE) : (object instanceof short[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((short[])((short[])value)), module, PrimitiveType.SHORT) : (object instanceof int[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((int[])((int[])value)), module, PrimitiveType.INT) : (object instanceof long[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((long[])((long[])value)), module, PrimitiveType.LONG) : (object instanceof char[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((char[])((char[])value)), module, PrimitiveType.CHAR) : (object instanceof float[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((float[])((float[])value)), module, PrimitiveType.FLOAT) : (object instanceof double[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((double[])((double[])value)), module, PrimitiveType.DOUBLE) : (object instanceof boolean[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((boolean[])((boolean[])value)), module, PrimitiveType.BOOLEAN) : (object == null ? (ConstantValue)new NullValue() : null)))))))))))))))));
    }

    public static /* synthetic */ ConstantValue createConstantValue$default(ConstantValueFactory constantValueFactory, Object object, ModuleDescriptor moduleDescriptor, int n, Object object2) {
        if ((n & 2) != 0) {
            moduleDescriptor = null;
        }
        return constantValueFactory.createConstantValue(object, moduleDescriptor);
    }

    @Nullable
    public final UnsignedValueConstant<?> createUnsignedValue(@NotNull ConstantValue<?> constantValue) {
        Intrinsics.checkNotNullParameter(constantValue, (String)"constantValue");
        ConstantValue<?> constantValue2 = constantValue;
        return constantValue2 instanceof ByteValue ? (UnsignedValueConstant)new UByteValue(((Number)((ByteValue)constantValue).getValue()).byteValue()) : (constantValue2 instanceof ShortValue ? (UnsignedValueConstant)new UShortValue(((Number)((ShortValue)constantValue).getValue()).shortValue()) : (constantValue2 instanceof IntValue ? (UnsignedValueConstant)new UIntValue(((Number)((IntValue)constantValue).getValue()).intValue()) : (constantValue2 instanceof LongValue ? (UnsignedValueConstant)new ULongValue(((Number)((LongValue)constantValue).getValue()).longValue()) : null)));
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayValue createArrayValue(List<?> value, ModuleDescriptor module, PrimitiveType componentType) {
        ArrayValue arrayValue;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.toList((Iterable)value);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConstantValue it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Object p0 = element$iv$iv;
            boolean bl2 = false;
            if (ConstantValueFactory.createConstantValue$default(this, p0, null, 2, null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List elements = (List)destination$iv$iv;
        if (module != null) {
            SimpleType simpleType = module.getBuiltIns().getPrimitiveArrayKotlinType(componentType);
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getPrimitiveArrayKotlinType(...)");
            arrayValue = new TypedArrayValue(elements, simpleType);
        } else {
            arrayValue = new ArrayValue(elements, (Function1<? super ModuleDescriptor, ? extends KotlinType>)((Function1)arg_0 -> ConstantValueFactory.createArrayValue$lambda$0(componentType, arg_0)));
        }
        return arrayValue;
    }

    @Nullable
    public final ConstantValue<?> createIntegerConstantValue(long value, @NotNull KotlinType expectedType, boolean isUnsigned) {
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        KotlinType kotlinType = TypeUtils.makeNotNullable(expectedType);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"makeNotNullable(...)");
        KotlinType notNullExpected = kotlinType;
        return isUnsigned ? (ConstantValue)(KotlinBuiltIns.isUByte(notNullExpected) && value == ConstantValueFactoryKt.fromUByteToLong((byte)value) ? (UnsignedValueConstant)new UByteValue((byte)value) : (KotlinBuiltIns.isUShort(notNullExpected) && value == ConstantValueFactoryKt.fromUShortToLong((short)value) ? (UnsignedValueConstant)new UShortValue((short)value) : (KotlinBuiltIns.isUInt(notNullExpected) && value == ConstantValueFactoryKt.fromUIntToLong((int)value) ? (UnsignedValueConstant)new UIntValue((int)value) : (KotlinBuiltIns.isULong(notNullExpected) ? (UnsignedValueConstant)new ULongValue(value) : null)))) : (ConstantValue)(KotlinBuiltIns.isLong(notNullExpected) ? (IntegerValueConstant)new LongValue(value) : (KotlinBuiltIns.isInt(notNullExpected) && value == (long)((int)value) ? (IntegerValueConstant)new IntValue((int)value) : (KotlinBuiltIns.isShort(notNullExpected) && value == (long)((short)value) ? (IntegerValueConstant)new ShortValue((short)value) : (KotlinBuiltIns.isByte(notNullExpected) && value == (long)((byte)value) ? (IntegerValueConstant)new ByteValue((byte)value) : (KotlinBuiltIns.isChar(notNullExpected) ? (IntegerValueConstant)new IntValue((int)value) : null)))));
    }

    private static final KotlinType createArrayValue$lambda$0(PrimitiveType $componentType, ModuleDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SimpleType simpleType = it.getBuiltIns().getPrimitiveArrayKotlinType($componentType);
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getPrimitiveArrayKotlinType(...)");
        return simpleType;
    }
}

