/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CompileTimeConstant<T> {
    public boolean isError();

    @NotNull
    public Parameters getParameters();

    @NotNull
    public ModuleDescriptor getModuleDescriptor();

    @NotNull
    public ConstantValue<T> toConstantValue(@NotNull KotlinType var1);

    public T getValue(@NotNull KotlinType var1);

    public boolean getCanBeUsedInAnnotations();

    public boolean getUsesVariableAsConstant();

    public boolean getUsesNonConstValAsConstant();

    public boolean isPure();

    public boolean isUnsignedNumberLiteral();

    public boolean getHasIntegerLiteralType();

    public boolean equals(@Nullable Object var1);

    public int hashCode();

    public static final class DefaultImpls {
        public static <T> boolean isError(@NotNull CompileTimeConstant<? extends T> $this) {
            return false;
        }

        public static <T> T getValue(@NotNull CompileTimeConstant<? extends T> $this, @NotNull KotlinType expectedType) {
            Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
            return $this.toConstantValue(expectedType).getValue();
        }

        public static <T> boolean getCanBeUsedInAnnotations(@NotNull CompileTimeConstant<? extends T> $this) {
            return $this.getParameters().getCanBeUsedInAnnotation();
        }

        public static <T> boolean getUsesVariableAsConstant(@NotNull CompileTimeConstant<? extends T> $this) {
            return $this.getParameters().getUsesVariableAsConstant();
        }

        public static <T> boolean getUsesNonConstValAsConstant(@NotNull CompileTimeConstant<? extends T> $this) {
            return $this.getParameters().getUsesNonConstValAsConstant();
        }

        public static <T> boolean isPure(@NotNull CompileTimeConstant<? extends T> $this) {
            return $this.getParameters().isPure();
        }

        public static <T> boolean isUnsignedNumberLiteral(@NotNull CompileTimeConstant<? extends T> $this) {
            return $this.getParameters().isUnsignedNumberLiteral();
        }
    }

    public static final class Parameters {
        private final boolean canBeUsedInAnnotation;
        private final boolean isPure;
        private final boolean isUnsignedNumberLiteral;
        private final boolean isUnsignedLongNumberLiteral;
        private final boolean usesVariableAsConstant;
        private final boolean usesNonConstValAsConstant;
        private final boolean isConvertableConstVal;

        public Parameters(boolean canBeUsedInAnnotation, boolean isPure, boolean isUnsignedNumberLiteral, boolean isUnsignedLongNumberLiteral, boolean usesVariableAsConstant, boolean usesNonConstValAsConstant, boolean isConvertableConstVal) {
            this.canBeUsedInAnnotation = canBeUsedInAnnotation;
            this.isPure = isPure;
            this.isUnsignedNumberLiteral = isUnsignedNumberLiteral;
            this.isUnsignedLongNumberLiteral = isUnsignedLongNumberLiteral;
            this.usesVariableAsConstant = usesVariableAsConstant;
            this.usesNonConstValAsConstant = usesNonConstValAsConstant;
            this.isConvertableConstVal = isConvertableConstVal;
        }

        public final boolean getCanBeUsedInAnnotation() {
            return this.canBeUsedInAnnotation;
        }

        public final boolean isPure() {
            return this.isPure;
        }

        public final boolean isUnsignedNumberLiteral() {
            return this.isUnsignedNumberLiteral;
        }

        public final boolean isUnsignedLongNumberLiteral() {
            return this.isUnsignedLongNumberLiteral;
        }

        public final boolean getUsesVariableAsConstant() {
            return this.usesVariableAsConstant;
        }

        public final boolean getUsesNonConstValAsConstant() {
            return this.usesNonConstValAsConstant;
        }

        public final boolean isConvertableConstVal() {
            return this.isConvertableConstVal;
        }

        public final boolean component1() {
            return this.canBeUsedInAnnotation;
        }

        public final boolean component2() {
            return this.isPure;
        }

        public final boolean component3() {
            return this.isUnsignedNumberLiteral;
        }

        public final boolean component4() {
            return this.isUnsignedLongNumberLiteral;
        }

        public final boolean component5() {
            return this.usesVariableAsConstant;
        }

        public final boolean component6() {
            return this.usesNonConstValAsConstant;
        }

        public final boolean component7() {
            return this.isConvertableConstVal;
        }

        @NotNull
        public final Parameters copy(boolean canBeUsedInAnnotation, boolean isPure, boolean isUnsignedNumberLiteral, boolean isUnsignedLongNumberLiteral, boolean usesVariableAsConstant, boolean usesNonConstValAsConstant, boolean isConvertableConstVal) {
            return new Parameters(canBeUsedInAnnotation, isPure, isUnsignedNumberLiteral, isUnsignedLongNumberLiteral, usesVariableAsConstant, usesNonConstValAsConstant, isConvertableConstVal);
        }

        public static /* synthetic */ Parameters copy$default(Parameters parameters, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, Object object) {
            if ((n & 1) != 0) {
                bl = parameters.canBeUsedInAnnotation;
            }
            if ((n & 2) != 0) {
                bl2 = parameters.isPure;
            }
            if ((n & 4) != 0) {
                bl3 = parameters.isUnsignedNumberLiteral;
            }
            if ((n & 8) != 0) {
                bl4 = parameters.isUnsignedLongNumberLiteral;
            }
            if ((n & 0x10) != 0) {
                bl5 = parameters.usesVariableAsConstant;
            }
            if ((n & 0x20) != 0) {
                bl6 = parameters.usesNonConstValAsConstant;
            }
            if ((n & 0x40) != 0) {
                bl7 = parameters.isConvertableConstVal;
            }
            return parameters.copy(bl, bl2, bl3, bl4, bl5, bl6, bl7);
        }

        @NotNull
        public String toString() {
            return "Parameters(canBeUsedInAnnotation=" + this.canBeUsedInAnnotation + ", isPure=" + this.isPure + ", isUnsignedNumberLiteral=" + this.isUnsignedNumberLiteral + ", isUnsignedLongNumberLiteral=" + this.isUnsignedLongNumberLiteral + ", usesVariableAsConstant=" + this.usesVariableAsConstant + ", usesNonConstValAsConstant=" + this.usesNonConstValAsConstant + ", isConvertableConstVal=" + this.isConvertableConstVal + ')';
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.canBeUsedInAnnotation);
            result = result * 31 + Boolean.hashCode(this.isPure);
            result = result * 31 + Boolean.hashCode(this.isUnsignedNumberLiteral);
            result = result * 31 + Boolean.hashCode(this.isUnsignedLongNumberLiteral);
            result = result * 31 + Boolean.hashCode(this.usesVariableAsConstant);
            result = result * 31 + Boolean.hashCode(this.usesNonConstValAsConstant);
            result = result * 31 + Boolean.hashCode(this.isConvertableConstVal);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parameters)) {
                return false;
            }
            Parameters parameters = (Parameters)other;
            if (this.canBeUsedInAnnotation != parameters.canBeUsedInAnnotation) {
                return false;
            }
            if (this.isPure != parameters.isPure) {
                return false;
            }
            if (this.isUnsignedNumberLiteral != parameters.isUnsignedNumberLiteral) {
                return false;
            }
            if (this.isUnsignedLongNumberLiteral != parameters.isUnsignedLongNumberLiteral) {
                return false;
            }
            if (this.usesVariableAsConstant != parameters.usesVariableAsConstant) {
                return false;
            }
            if (this.usesNonConstValAsConstant != parameters.usesNonConstValAsConstant) {
                return false;
            }
            return this.isConvertableConstVal == parameters.isConvertableConstVal;
        }
    }
}

