/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.checkers;

import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.KotlinTarget;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptInDescription {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName annotationFqName;
    @NotNull
    private final Severity severity;
    @Nullable
    private final String message;
    private final boolean subclassesOnly;
    @NotNull
    private static final Severity DEFAULT_SEVERITY = Severity.ERROR;
    @NotNull
    private static final Set<KotlinTarget> WRONG_TARGETS_FOR_MARKER;

    public OptInDescription(@NotNull FqName annotationFqName, @NotNull Severity severity, @Nullable String message, boolean subclassesOnly) {
        Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        this.annotationFqName = annotationFqName;
        this.severity = severity;
        this.message = message;
        this.subclassesOnly = subclassesOnly;
    }

    @NotNull
    public final FqName getAnnotationFqName() {
        return this.annotationFqName;
    }

    @NotNull
    public final Severity getSeverity() {
        return this.severity;
    }

    @Nullable
    public final String getMessage() {
        return this.message;
    }

    public final boolean getSubclassesOnly() {
        return this.subclassesOnly;
    }

    @NotNull
    public final FqName component1() {
        return this.annotationFqName;
    }

    @NotNull
    public final Severity component2() {
        return this.severity;
    }

    @Nullable
    public final String component3() {
        return this.message;
    }

    public final boolean component4() {
        return this.subclassesOnly;
    }

    @NotNull
    public final OptInDescription copy(@NotNull FqName annotationFqName, @NotNull Severity severity, @Nullable String message, boolean subclassesOnly) {
        Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        return new OptInDescription(annotationFqName, severity, message, subclassesOnly);
    }

    public static /* synthetic */ OptInDescription copy$default(OptInDescription optInDescription, FqName fqName, Severity severity, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            fqName = optInDescription.annotationFqName;
        }
        if ((n & 2) != 0) {
            severity = optInDescription.severity;
        }
        if ((n & 4) != 0) {
            string = optInDescription.message;
        }
        if ((n & 8) != 0) {
            bl = optInDescription.subclassesOnly;
        }
        return optInDescription.copy(fqName, severity, string, bl);
    }

    @NotNull
    public String toString() {
        return "OptInDescription(annotationFqName=" + this.annotationFqName + ", severity=" + (Object)((Object)this.severity) + ", message=" + this.message + ", subclassesOnly=" + this.subclassesOnly + ')';
    }

    public int hashCode() {
        int result = this.annotationFqName.hashCode();
        result = result * 31 + this.severity.hashCode();
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + Boolean.hashCode(this.subclassesOnly);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OptInDescription)) {
            return false;
        }
        OptInDescription optInDescription = (OptInDescription)other;
        if (!Intrinsics.areEqual((Object)this.annotationFqName, (Object)optInDescription.annotationFqName)) {
            return false;
        }
        if (this.severity != optInDescription.severity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)optInDescription.message)) {
            return false;
        }
        return this.subclassesOnly == optInDescription.subclassesOnly;
    }

    static {
        KotlinTarget[] kotlinTargetArray = new KotlinTarget[]{KotlinTarget.EXPRESSION, KotlinTarget.FILE, KotlinTarget.TYPE, KotlinTarget.TYPE_PARAMETER};
        WRONG_TARGETS_FOR_MARKER = SetsKt.setOf((Object[])kotlinTargetArray);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Severity getDEFAULT_SEVERITY() {
            return DEFAULT_SEVERITY;
        }

        @NotNull
        public final Set<KotlinTarget> getWRONG_TARGETS_FOR_MARKER() {
            return WRONG_TARGETS_FOR_MARKER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Severity
    extends Enum<Severity> {
        public static final /* enum */ Severity WARNING = new Severity();
        public static final /* enum */ Severity ERROR = new Severity();
        public static final /* enum */ Severity FUTURE_ERROR = new Severity();
        private static final /* synthetic */ Severity[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Severity[] values() {
            return (Severity[])$VALUES.clone();
        }

        public static Severity valueOf(String value) {
            return Enum.valueOf(Severity.class, value);
        }

        @NotNull
        public static EnumEntries<Severity> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = severityArray = new Severity[]{Severity.WARNING, Severity.ERROR, Severity.FUTURE_ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

