/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.checkers.EmptyIntersectionTypeInfo;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.EmptyIntersectionTypeKind;
import kotlin.reflect.jvm.internal.impl.types.TypeCheckerState;
import kotlin.reflect.jvm.internal.impl.types.model.IntersectionTypeConstructorMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.RigidTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeCheckerProviderContext;
import kotlin.reflect.jvm.internal.impl.types.model.TypeConstructorMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmptyIntersectionTypeChecker {
    @NotNull
    public static final EmptyIntersectionTypeChecker INSTANCE = new EmptyIntersectionTypeChecker();

    private EmptyIntersectionTypeChecker() {
    }

    @Nullable
    public final EmptyIntersectionTypeInfo computeEmptyIntersectionEmptiness(@NotNull TypeSystemInferenceExtensionContext context, @NotNull Collection<? extends KotlinTypeMarker> types) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        TypeSystemInferenceExtensionContext $this$computeEmptyIntersectionEmptiness_u24lambda_u242 = context;
        boolean bl = false;
        if (types.isEmpty()) {
            return null;
        }
        List types2 = CollectionsKt.toList((Iterable)types);
        EmptyIntersectionTypeInfo possibleEmptyIntersectionTypeInfo = null;
        int n = ((Collection)types2).size();
        for (int i = 0; i < n; ++i) {
            KotlinTypeMarker firstType = (KotlinTypeMarker)types2.get(i);
            if (!INSTANCE.mayCauseEmptyIntersection($this$computeEmptyIntersectionEmptiness_u24lambda_u242, firstType)) continue;
            Lazy firstSubstitutedType$delegate = LazyKt.lazy(() -> EmptyIntersectionTypeChecker.computeEmptyIntersectionEmptiness$lambda$2$lambda$0($this$computeEmptyIntersectionEmptiness_u24lambda_u242, firstType));
            int n2 = types2.size();
            for (int j = i + 1; j < n2; ++j) {
                EmptyIntersectionTypeInfo typeInfo;
                KotlinTypeMarker secondSubstitutedType;
                KotlinTypeMarker secondType = (KotlinTypeMarker)types2.get(j);
                if (!INSTANCE.mayCauseEmptyIntersection($this$computeEmptyIntersectionEmptiness_u24lambda_u242, secondType) || !INSTANCE.mayCauseEmptyIntersection($this$computeEmptyIntersectionEmptiness_u24lambda_u242, secondSubstitutedType = $this$computeEmptyIntersectionEmptiness_u24lambda_u242.eraseContainingTypeParameters(secondType)) && !INSTANCE.mayCauseEmptyIntersection($this$computeEmptyIntersectionEmptiness_u24lambda_u242, EmptyIntersectionTypeChecker.computeEmptyIntersectionEmptiness$lambda$2$lambda$1((Lazy<? extends KotlinTypeMarker>)firstSubstitutedType$delegate)) || INSTANCE.computeByHavingCommonSubtype($this$computeEmptyIntersectionEmptiness_u24lambda_u242, EmptyIntersectionTypeChecker.computeEmptyIntersectionEmptiness$lambda$2$lambda$1((Lazy<? extends KotlinTypeMarker>)firstSubstitutedType$delegate), secondSubstitutedType) == null) continue;
                if (typeInfo.getKind().isDefinitelyEmpty()) {
                    return typeInfo;
                }
                if (typeInfo.getKind().isDefinitelyEmpty()) continue;
                possibleEmptyIntersectionTypeInfo = typeInfo;
            }
        }
        return possibleEmptyIntersectionTypeInfo;
    }

    private final EmptyIntersectionTypeInfo computeByHavingCommonSubtype(TypeSystemInferenceExtensionContext $this$computeByHavingCommonSubtype, KotlinTypeMarker first, KotlinTypeMarker second) {
        List expandedTypes = CollectionsKt.plus((Collection)EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$extractIntersectionComponentsIfNeeded($this$computeByHavingCommonSubtype, first), (Iterable)EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$extractIntersectionComponentsIfNeeded($this$computeByHavingCommonSubtype, second));
        Lazy typeCheckerState$delegate = LazyKt.lazy(() -> EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$lambda$3($this$computeByHavingCommonSubtype));
        EmptyIntersectionTypeInfo possibleEmptyIntersectionKind = null;
        int n = ((Collection)expandedTypes).size();
        for (int i = 0; i < n; ++i) {
            KotlinTypeMarker firstType = $this$computeByHavingCommonSubtype.withNullability((KotlinTypeMarker)expandedTypes.get(i), false);
            TypeConstructorMarker firstTypeConstructor = $this$computeByHavingCommonSubtype.typeConstructor(firstType);
            if (!this.mayCauseEmptyIntersection($this$computeByHavingCommonSubtype, firstType)) continue;
            int n2 = expandedTypes.size();
            for (int j = i + 1; j < n2; ++j) {
                KotlinTypeMarker[] kotlinTypeMarkerArray;
                KotlinTypeMarker secondType = $this$computeByHavingCommonSubtype.withNullability((KotlinTypeMarker)expandedTypes.get(j), false);
                TypeConstructorMarker secondTypeConstructor = $this$computeByHavingCommonSubtype.typeConstructor(secondType);
                if (!this.mayCauseEmptyIntersection($this$computeByHavingCommonSubtype, secondType) || $this$computeByHavingCommonSubtype.areEqualTypeConstructors(firstTypeConstructor, secondTypeConstructor) || this.isSubtypeOfIgnoringArguments($this$computeByHavingCommonSubtype.lowerBoundIfFlexible(firstType), EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$lambda$4((Lazy<? extends TypeCheckerState>)typeCheckerState$delegate), secondTypeConstructor) || this.isSubtypeOfIgnoringArguments($this$computeByHavingCommonSubtype.lowerBoundIfFlexible(secondType), EmptyIntersectionTypeChecker.computeByHavingCommonSubtype$lambda$4((Lazy<? extends TypeCheckerState>)typeCheckerState$delegate), firstTypeConstructor)) continue;
                if (!$this$computeByHavingCommonSubtype.isInterface(firstTypeConstructor) && !$this$computeByHavingCommonSubtype.isInterface(secondTypeConstructor)) {
                    kotlinTypeMarkerArray = new KotlinTypeMarker[]{firstType, secondType};
                    return new EmptyIntersectionTypeInfo(EmptyIntersectionTypeKind.MULTIPLE_CLASSES, kotlinTypeMarkerArray);
                }
                if (!$this$computeByHavingCommonSubtype.isFinalClassConstructor(firstTypeConstructor) && !$this$computeByHavingCommonSubtype.isFinalClassConstructor(secondTypeConstructor)) continue;
                kotlinTypeMarkerArray = new KotlinTypeMarker[]{firstType, secondType};
                possibleEmptyIntersectionKind = new EmptyIntersectionTypeInfo(EmptyIntersectionTypeKind.FINAL_CLASS_AND_INTERFACE, kotlinTypeMarkerArray);
            }
        }
        return possibleEmptyIntersectionKind;
    }

    private final boolean isSubtypeOfIgnoringArguments(RigidTypeMarker $this$isSubtypeOfIgnoringArguments, TypeCheckerState typeCheckerState, TypeConstructorMarker otherConstructorMarker) {
        return !((Collection)AbstractTypeChecker.INSTANCE.findCorrespondingSupertypes(typeCheckerState, $this$isSubtypeOfIgnoringArguments, otherConstructorMarker)).isEmpty();
    }

    private final boolean mayCauseEmptyIntersection(TypeSystemInferenceExtensionContext $this$mayCauseEmptyIntersection, KotlinTypeMarker type) {
        if ($this$mayCauseEmptyIntersection.isStubType($this$mayCauseEmptyIntersection.lowerBoundIfFlexible(type)) || $this$mayCauseEmptyIntersection.isError(type)) {
            return false;
        }
        TypeConstructorMarker typeConstructor2 = $this$mayCauseEmptyIntersection.typeConstructor(type);
        if (!$this$mayCauseEmptyIntersection.isClassTypeConstructor(typeConstructor2) && !$this$mayCauseEmptyIntersection.isTypeParameterTypeConstructor(typeConstructor2)) {
            return false;
        }
        return !$this$mayCauseEmptyIntersection.isAnyConstructor(typeConstructor2) && !$this$mayCauseEmptyIntersection.isNothingConstructor(typeConstructor2);
    }

    private static final KotlinTypeMarker computeEmptyIntersectionEmptiness$lambda$2$lambda$0(TypeSystemInferenceExtensionContext $this_with, KotlinTypeMarker $firstType) {
        return $this_with.eraseContainingTypeParameters($firstType);
    }

    private static final KotlinTypeMarker computeEmptyIntersectionEmptiness$lambda$2$lambda$1(Lazy<? extends KotlinTypeMarker> $firstSubstitutedType$delegate) {
        Lazy<? extends KotlinTypeMarker> lazy = $firstSubstitutedType$delegate;
        return (KotlinTypeMarker)lazy.getValue();
    }

    private static final List<KotlinTypeMarker> computeByHavingCommonSubtype$extractIntersectionComponentsIfNeeded(TypeSystemInferenceExtensionContext $this_computeByHavingCommonSubtype, KotlinTypeMarker type) {
        return $this_computeByHavingCommonSubtype.typeConstructor(type) instanceof IntersectionTypeConstructorMarker ? CollectionsKt.toList((Iterable)$this_computeByHavingCommonSubtype.supertypes($this_computeByHavingCommonSubtype.typeConstructor(type))) : CollectionsKt.listOf((Object)type);
    }

    private static final TypeCheckerState computeByHavingCommonSubtype$lambda$3(TypeSystemInferenceExtensionContext $this_computeByHavingCommonSubtype) {
        return TypeCheckerProviderContext.newTypeCheckerState$default($this_computeByHavingCommonSubtype, true, true, false, 4, null);
    }

    private static final TypeCheckerState computeByHavingCommonSubtype$lambda$4(Lazy<? extends TypeCheckerState> $typeCheckerState$delegate) {
        Lazy<? extends TypeCheckerState> lazy = $typeCheckerState$delegate;
        return (TypeCheckerState)lazy.getValue();
    }
}

