/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.calls.inference;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorImpl;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SubtypingRepresentatives;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeRefinement;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScopeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

public final class CapturedType
extends SimpleType
implements SubtypingRepresentatives,
CapturedTypeMarker {
    @NotNull
    private final TypeProjection typeProjection;
    @NotNull
    private final CapturedTypeConstructor constructor;
    private final boolean isMarkedNullable;
    @NotNull
    private final TypeAttributes attributes;

    public CapturedType(@NotNull TypeProjection typeProjection, @NotNull CapturedTypeConstructor constructor, boolean isMarkedNullable, @NotNull TypeAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)typeProjection, (String)"typeProjection");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.typeProjection = typeProjection;
        this.constructor = constructor;
        this.isMarkedNullable = isMarkedNullable;
        this.attributes = attributes;
    }

    public /* synthetic */ CapturedType(TypeProjection typeProjection, CapturedTypeConstructor capturedTypeConstructor, boolean bl, TypeAttributes typeAttributes, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            capturedTypeConstructor = new CapturedTypeConstructorImpl(typeProjection);
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            typeAttributes = TypeAttributes.Companion.getEmpty();
        }
        this(typeProjection, capturedTypeConstructor, bl, typeAttributes);
    }

    @NotNull
    public final TypeProjection getTypeProjection() {
        return this.typeProjection;
    }

    @Override
    @NotNull
    public CapturedTypeConstructor getConstructor() {
        return this.constructor;
    }

    @Override
    public boolean isMarkedNullable() {
        return this.isMarkedNullable;
    }

    @Override
    @NotNull
    public TypeAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public MemberScope getMemberScope() {
        return ErrorUtils.createErrorScope(ErrorScopeKind.CAPTURED_TYPE_SCOPE, true, new String[0]);
    }

    @Override
    @NotNull
    public KotlinType getSubTypeRepresentative() {
        SimpleType simpleType = TypeUtilsKt.getBuiltIns(this).getNullableAnyType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getNullableAnyType(...)");
        return this.representative(Variance.OUT_VARIANCE, simpleType);
    }

    @Override
    @NotNull
    public KotlinType getSuperTypeRepresentative() {
        SimpleType simpleType = TypeUtilsKt.getBuiltIns(this).getNothingType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getNothingType(...)");
        return this.representative(Variance.IN_VARIANCE, simpleType);
    }

    private final KotlinType representative(Variance variance, KotlinType kotlinType) {
        KotlinType kotlinType2 = this.typeProjection.getProjectionKind() == variance ? this.typeProjection.getType() : kotlinType;
        Intrinsics.checkNotNull((Object)kotlinType2);
        return kotlinType2;
    }

    @Override
    public boolean sameTypeConstructor(@NotNull KotlinType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.getConstructor() == type.getConstructor();
    }

    @Override
    @NotNull
    public String toString() {
        return "Captured(" + this.typeProjection + ')' + (this.isMarkedNullable() ? "?" : "");
    }

    @Override
    @NotNull
    public CapturedType makeNullableAsSpecified(boolean newNullability) {
        if (newNullability == this.isMarkedNullable()) {
            return this;
        }
        return new CapturedType(this.typeProjection, this.getConstructor(), newNullability, this.getAttributes());
    }

    @Override
    @NotNull
    public SimpleType replaceAttributes(@NotNull TypeAttributes newAttributes) {
        Intrinsics.checkNotNullParameter((Object)newAttributes, (String)"newAttributes");
        return new CapturedType(this.typeProjection, this.getConstructor(), this.isMarkedNullable(), newAttributes);
    }

    @Override
    @TypeRefinement
    @NotNull
    public CapturedType refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        TypeProjection typeProjection = this.typeProjection.refine(kotlinTypeRefiner);
        Intrinsics.checkNotNullExpressionValue((Object)typeProjection, (String)"refine(...)");
        return new CapturedType(typeProjection, this.getConstructor(), this.isMarkedNullable(), this.getAttributes());
    }
}

