/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingUtil;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\noverridingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 overridingUtils.kt\norg/jetbrains/kotlin/resolve/OverridingUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1634#2,3:85\n855#2,2:88\n*S KotlinDebug\n*F\n+ 1 overridingUtils.kt\norg/jetbrains/kotlin/resolve/OverridingUtilsKt\n*L\n40#1:85,3\n72#1:88,2\n*E\n"})
public final class OverridingUtilsKt {
    @NotNull
    public static final <D extends CallableDescriptor> List<D> findTopMostOverriddenDescriptors(@NotNull D $this$findTopMostOverriddenDescriptors) {
        Intrinsics.checkNotNullParameter($this$findTopMostOverriddenDescriptors, (String)"<this>");
        ArrayList arrayList = new ArrayList();
        Object r = DFS.dfs(CollectionsKt.listOf($this$findTopMostOverriddenDescriptors), OverridingUtilsKt::findTopMostOverriddenDescriptors$lambda$0, new DFS.CollectingNodeHandler<CallableDescriptor, CallableDescriptor, ArrayList<D>>(arrayList){

            public void afterChildren(CallableDescriptor current) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                if (current.getOverriddenDescriptors().isEmpty()) {
                    ((ArrayList)this.result).add(current);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue(r, (String)"dfs(...)");
        return (List)r;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <D extends CallableDescriptor> Set<D> findOriginalTopMostOverriddenDescriptors(@NotNull D $this$findOriginalTopMostOverriddenDescriptors) {
        void var2_2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter($this$findOriginalTopMostOverriddenDescriptors, (String)"<this>");
        Iterable iterable = OverridingUtilsKt.findTopMostOverriddenDescriptors($this$findOriginalTopMostOverriddenDescriptors);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            CallableDescriptor callableDescriptor = (CallableDescriptor)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            CallableDescriptor callableDescriptor2 = it.getOriginal();
            Intrinsics.checkNotNull((Object)callableDescriptor2, (String)"null cannot be cast to non-null type D of org.jetbrains.kotlin.resolve.OverridingUtilsKt.findOriginalTopMostOverriddenDescriptors");
            collection.add(callableDescriptor2);
        }
        return (Set)var2_2;
    }

    @NotNull
    public static final <H> Collection<H> selectMostSpecificInEachOverridableGroup(@NotNull Collection<? extends H> $this$selectMostSpecificInEachOverridableGroup, @NotNull Function1<? super H, ? extends CallableDescriptor> descriptorByHandle) {
        Intrinsics.checkNotNullParameter($this$selectMostSpecificInEachOverridableGroup, (String)"<this>");
        Intrinsics.checkNotNullParameter(descriptorByHandle, (String)"descriptorByHandle");
        if ($this$selectMostSpecificInEachOverridableGroup.size() <= 1) {
            return $this$selectMostSpecificInEachOverridableGroup;
        }
        LinkedList<? extends H> queue = new LinkedList<H>($this$selectMostSpecificInEachOverridableGroup);
        SmartSet result = SmartSet.Companion.create();
        while (!((Collection)queue).isEmpty()) {
            Collection<H> overridableGroup;
            Object nextHandle = CollectionsKt.first((List)queue);
            SmartSet conflictedHandles = SmartSet.Companion.create();
            Intrinsics.checkNotNullExpressionValue(OverridingUtil.extractMembersOverridableInBothWays(nextHandle, (Collection)queue, descriptorByHandle, arg_0 -> OverridingUtilsKt.selectMostSpecificInEachOverridableGroup$lambda$2(conflictedHandles, arg_0)), (String)"extractMembersOverridableInBothWays(...)");
            if (overridableGroup.size() == 1 && conflictedHandles.isEmpty()) {
                Object object = CollectionsKt.single((Iterable)overridableGroup);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"single(...)");
                result.add(object);
                continue;
            }
            H mostSpecific = OverridingUtil.selectMostSpecificMember(overridableGroup, descriptorByHandle);
            CallableDescriptor mostSpecificDescriptor = (CallableDescriptor)descriptorByHandle.invoke(mostSpecific);
            Iterable $this$filterNotTo$iv = overridableGroup;
            boolean $i$f$filterNotTo = false;
            Iterator iterator2 = $this$filterNotTo$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (OverridingUtil.isMoreSpecific(mostSpecificDescriptor, (CallableDescriptor)descriptorByHandle.invoke(it))) continue;
                ((Collection)((Object)conflictedHandles)).add(element$iv);
            }
            Collection cfr_ignored_0 = (Collection)((Object)conflictedHandles);
            if (!((Collection)((Object)conflictedHandles)).isEmpty()) {
                result.addAll((Collection)((Object)conflictedHandles));
            }
            result.add(mostSpecific);
        }
        return (Collection)((Object)result);
    }

    private static final Iterable findTopMostOverriddenDescriptors$lambda$0(CallableDescriptor current) {
        return current.getOverriddenDescriptors();
    }

    private static final Unit selectMostSpecificInEachOverridableGroup$lambda$2(SmartSet $conflictedHandles, Object it) {
        Intrinsics.checkNotNull((Object)it);
        $conflictedHandles.add(it);
        return Unit.INSTANCE;
    }
}

