/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.InlineClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.MultiFieldValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.SimpleClassicTypeSystemContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\ninlineClassesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 inlineClassesUtils.kt\norg/jetbrains/kotlin/resolve/InlineClassesUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1563#2:89\n1634#2,3:90\n1563#2:94\n1634#2,3:95\n1761#2,3:98\n1#3:93\n*S KotlinDebug\n*F\n+ 1 inlineClassesUtils.kt\norg/jetbrains/kotlin/resolve/InlineClassesUtilsKt\n*L\n38#1:89\n38#1:90,3\n54#1:94\n54#1:95,3\n65#1:98,3\n*E\n"})
public final class InlineClassesUtilsKt {
    @NotNull
    private static final FqName JVM_INLINE_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmInline");
    @NotNull
    private static final ClassId JVM_INLINE_ANNOTATION_CLASS_ID = ClassId.Companion.topLevel(JVM_INLINE_ANNOTATION_FQ_NAME);

    @NotNull
    public static final FqName getJVM_INLINE_ANNOTATION_FQ_NAME() {
        return JVM_INLINE_ANNOTATION_FQ_NAME;
    }

    @NotNull
    public static final ClassId getJVM_INLINE_ANNOTATION_CLASS_ID() {
        return JVM_INLINE_ANNOTATION_CLASS_ID;
    }

    public static final boolean isInlineClass(@NotNull DeclarationDescriptor $this$isInlineClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClass, (String)"<this>");
        return $this$isInlineClass instanceof ClassDescriptor && ((ClassDescriptor)$this$isInlineClass).getValueClassRepresentation() instanceof InlineClassRepresentation;
    }

    public static final boolean isMultiFieldValueClass(@NotNull DeclarationDescriptor $this$isMultiFieldValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isMultiFieldValueClass, (String)"<this>");
        return $this$isMultiFieldValueClass instanceof ClassDescriptor && ((ClassDescriptor)$this$isMultiFieldValueClass).getValueClassRepresentation() instanceof MultiFieldValueClassRepresentation;
    }

    public static final boolean isValueClass(@NotNull DeclarationDescriptor $this$isValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isValueClass, (String)"<this>");
        return InlineClassesUtilsKt.isInlineClass($this$isValueClass) || InlineClassesUtilsKt.isMultiFieldValueClass($this$isValueClass);
    }

    @Nullable
    public static final KotlinType unsubstitutedUnderlyingType(@NotNull KotlinType $this$unsubstitutedUnderlyingType) {
        Intrinsics.checkNotNullParameter((Object)$this$unsubstitutedUnderlyingType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$unsubstitutedUnderlyingType.getConstructor().getDeclarationDescriptor();
        Object object = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        return object != null && (object = DescriptorUtilsKt.getInlineClassRepresentation((ClassDescriptor)object)) != null ? (SimpleType)((InlineClassRepresentation)object).getUnderlyingType() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinType> unsubstitutedUnderlyingTypes(@NotNull KotlinType $this$unsubstitutedUnderlyingTypes) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$unsubstitutedUnderlyingTypes, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$unsubstitutedUnderlyingTypes.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ClassDescriptor declarationDescriptor = classDescriptor;
        if (InlineClassesUtilsKt.isInlineClass(declarationDescriptor)) {
            list = CollectionsKt.listOfNotNull((Object)InlineClassesUtilsKt.unsubstitutedUnderlyingType($this$unsubstitutedUnderlyingTypes));
        } else if (InlineClassesUtilsKt.isMultiFieldValueClass(declarationDescriptor)) {
            Object object = declarationDescriptor.getUnsubstitutedPrimaryConstructor();
            if (object != null && (object = object.getValueParameters()) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    KotlinType kotlinType = it.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                    collection.add(kotlinType);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static final boolean isInlineClassType(@NotNull KotlinType $this$isInlineClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClassType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isInlineClassType.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? InlineClassesUtilsKt.isInlineClass(classifierDescriptor) : false;
    }

    public static final boolean isValueClassType(@NotNull KotlinType $this$isValueClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$isValueClassType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isValueClassType.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? InlineClassesUtilsKt.isValueClass(classifierDescriptor) : false;
    }

    public static final boolean needsMfvcFlattening(@NotNull KotlinType $this$needsMfvcFlattening) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$needsMfvcFlattening, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$needsMfvcFlattening.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            ClassifierDescriptor $this$needsMfvcFlattening_u24lambda_u241 = classifierDescriptor;
            boolean bl2 = false;
            bl = InlineClassesUtilsKt.isMultiFieldValueClass($this$needsMfvcFlattening_u24lambda_u241) && !SimpleClassicTypeSystemContext.INSTANCE.isNullableType($this$needsMfvcFlattening);
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final KotlinType substitutedUnderlyingType(@NotNull KotlinType $this$substitutedUnderlyingType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$substitutedUnderlyingType, (String)"<this>");
        KotlinType kotlinType2 = InlineClassesUtilsKt.unsubstitutedUnderlyingType($this$substitutedUnderlyingType);
        if (kotlinType2 != null) {
            KotlinType it = kotlinType2;
            boolean bl = false;
            kotlinType = TypeSubstitutor.create($this$substitutedUnderlyingType).substitute(it, Variance.INVARIANT);
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinType> substitutedUnderlyingTypes(@NotNull KotlinType $this$substitutedUnderlyingTypes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$substitutedUnderlyingTypes, (String)"<this>");
        Iterable $this$map$iv = InlineClassesUtilsKt.unsubstitutedUnderlyingTypes($this$substitutedUnderlyingTypes);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TypeSubstitutor.create($this$substitutedUnderlyingTypes).substitute((KotlinType)it, Variance.INVARIANT));
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isRecursiveInlineOrValueClassType(@NotNull KotlinType $this$isRecursiveInlineOrValueClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$isRecursiveInlineOrValueClassType, (String)"<this>");
        return InlineClassesUtilsKt.isRecursiveInlineOrValueClassTypeInner($this$isRecursiveInlineOrValueClassType, new HashSet<ClassifierDescriptor>());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isRecursiveInlineOrValueClassTypeInner(KotlinType $this$isRecursiveInlineOrValueClassTypeInner, HashSet<ClassifierDescriptor> visited) {
        boolean bl;
        List<KotlinType> list;
        ClassifierDescriptor descriptor2;
        ClassifierDescriptor classifierDescriptor;
        Annotated it;
        ClassifierDescriptor classifierDescriptor2 = $this$isRecursiveInlineOrValueClassTypeInner.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor2 != null && (classifierDescriptor2 = classifierDescriptor2.getOriginal()) != null) {
            ClassifierDescriptor classifierDescriptor3 = classifierDescriptor2;
            it = classifierDescriptor3;
            boolean bl2 = false;
            classifierDescriptor = InlineClassesUtilsKt.isValueClass((DeclarationDescriptor)it) ? classifierDescriptor3 : null;
        } else {
            classifierDescriptor = descriptor2 = null;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            list = InlineClassesUtilsKt.isValueClass(descriptor2) ? InlineClassesUtilsKt.unsubstitutedUnderlyingTypes($this$isRecursiveInlineOrValueClassTypeInner) : CollectionsKt.emptyList();
        } else if (descriptor2 instanceof TypeParameterDescriptor) {
            List<KotlinType> list2 = ((TypeParameterDescriptor)descriptor2).getUpperBounds();
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getUpperBounds(...)");
        } else {
            list = CollectionsKt.emptyList();
        }
        List<KotlinType> types = list;
        Iterable $this$any$iv = types;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            boolean bl3;
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (KotlinType)element$iv;
            boolean bl4 = false;
            ClassifierDescriptor classifierDescriptor4 = ((KotlinType)it).getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor4 == null || (classifierDescriptor4 = classifierDescriptor4.getOriginal()) == null) {
                bl = false;
                continue;
            }
            ClassifierDescriptor classifier = classifierDescriptor4;
            if (!visited.add(classifier)) return true;
            boolean it2 = bl3 = InlineClassesUtilsKt.isRecursiveInlineOrValueClassTypeInner((KotlinType)it, visited);
            boolean bl5 = false;
            visited.remove(classifier);
            if (bl3) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final boolean isNullableUnderlyingType(@NotNull KotlinType $this$isNullableUnderlyingType) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullableUnderlyingType, (String)"<this>");
        if (!InlineClassesUtilsKt.isInlineClassType($this$isNullableUnderlyingType)) {
            return false;
        }
        KotlinType kotlinType = InlineClassesUtilsKt.unsubstitutedUnderlyingType($this$isNullableUnderlyingType);
        if (kotlinType == null) {
            return false;
        }
        KotlinType underlyingType = kotlinType;
        return TypeUtils.isNullableType(underlyingType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGetterOfUnderlyingPropertyOfValueClass(@NotNull CallableDescriptor $this$isGetterOfUnderlyingPropertyOfValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isGetterOfUnderlyingPropertyOfValueClass, (String)"<this>");
        if (!($this$isGetterOfUnderlyingPropertyOfValueClass instanceof PropertyGetterDescriptor)) return false;
        PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)$this$isGetterOfUnderlyingPropertyOfValueClass).getCorrespondingProperty();
        Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getCorrespondingProperty(...)");
        if (!InlineClassesUtilsKt.isUnderlyingPropertyOfValueClass(propertyDescriptor)) return false;
        return true;
    }

    public static final boolean isUnderlyingPropertyOfInlineClass(@NotNull VariableDescriptor $this$isUnderlyingPropertyOfInlineClass) {
        DeclarationDescriptor declarationDescriptor;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isUnderlyingPropertyOfInlineClass, (String)"<this>");
        return $this$isUnderlyingPropertyOfInlineClass.getExtensionReceiverParameter() == null && Intrinsics.areEqual((Object)((object = (declarationDescriptor = $this$isUnderlyingPropertyOfInlineClass.getContainingDeclaration()) instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null) != null && (object = DescriptorUtilsKt.getInlineClassRepresentation((ClassDescriptor)object)) != null ? ((InlineClassRepresentation)object).getUnderlyingPropertyName() : null), (Object)$this$isUnderlyingPropertyOfInlineClass.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isUnderlyingPropertyOfValueClass(@NotNull VariableDescriptor $this$isUnderlyingPropertyOfValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnderlyingPropertyOfValueClass, (String)"<this>");
        if ($this$isUnderlyingPropertyOfValueClass.getExtensionReceiverParameter() != null) return false;
        DeclarationDescriptor declarationDescriptor = $this$isUnderlyingPropertyOfValueClass.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) return false;
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        Object object = classDescriptor;
        if (classDescriptor == null) return false;
        ValueClassRepresentation<SimpleType> valueClassRepresentation = object.getValueClassRepresentation();
        object = valueClassRepresentation;
        if (valueClassRepresentation == null) return false;
        Name name = $this$isUnderlyingPropertyOfValueClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
        if (!((ValueClassRepresentation)object).containsPropertyWithName(name)) return false;
        return true;
    }
}

