/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.platform;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.platform.TargetPlatformVersion;
import org.jetbrains.annotations.NotNull;

public abstract class SimplePlatform {
    @NotNull
    private final String platformName;
    @NotNull
    private final TargetPlatformVersion targetPlatformVersion;

    public SimplePlatform(@NotNull String platformName) {
        Intrinsics.checkNotNullParameter((Object)platformName, (String)"platformName");
        this.platformName = platformName;
        this.targetPlatformVersion = TargetPlatformVersion.NoVersion.INSTANCE;
    }

    @NotNull
    public final String getPlatformName() {
        return this.platformName;
    }

    @NotNull
    public String toString() {
        String targetName = this.getTargetName();
        return ((CharSequence)targetName).length() > 0 ? this.platformName + " (" + targetName + ')' : this.platformName;
    }

    @NotNull
    public String getTargetName() {
        return this.getTargetPlatformVersion().getDescription();
    }

    @NotNull
    public abstract String getOldFashionedDescription();

    @NotNull
    public TargetPlatformVersion getTargetPlatformVersion() {
        return this.targetPlatformVersion;
    }
}

