/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.Locale;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class NameUtils {
    @NotNull
    public static final NameUtils INSTANCE = new NameUtils();
    @NotNull
    private static final Regex SANITIZE_AS_JAVA_INVALID_CHARACTERS = new Regex("[^\\p{L}\\p{Digit}]");
    @NotNull
    private static final String CONTEXT_RECEIVER_PREFIX = "$context_receiver";

    private NameUtils() {
    }

    @NotNull
    public static final String getCONTEXT_RECEIVER_PREFIX() {
        return CONTEXT_RECEIVER_PREFIX;
    }

    @JvmStatic
    public static /* synthetic */ void getCONTEXT_RECEIVER_PREFIX$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final String sanitizeAsJavaIdentifier(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return SANITIZE_AS_JAVA_INVALID_CHARACTERS.replace((CharSequence)name, "_");
    }

    @JvmStatic
    @NotNull
    public static final String getPackagePartClassNamePrefix(@NotNull String shortFileName) {
        Intrinsics.checkNotNullParameter((Object)shortFileName, (String)"shortFileName");
        return ((CharSequence)shortFileName).length() == 0 ? "_" : NameUtils.capitalizeAsJavaClassName(NameUtils.sanitizeAsJavaIdentifier(shortFileName));
    }

    @JvmStatic
    private static final String capitalizeAsJavaClassName(String str) {
        String string;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = String.valueOf(str.charAt(0));
            Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type java.lang.String");
            String string3 = string2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string3);
            String string4 = str.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string = stringBuilder2.append(string4).toString();
        } else {
            string = '_' + str;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Name getScriptNameForFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Name name = Name.identifier(NameUtils.getPackagePartClassNamePrefix(StringsKt.substringBeforeLast$default((String)StringsKt.substringAfterLast$default((String)filePath, (char)'/', null, (int)2, null), (char)'.', null, (int)2, null)));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return name;
    }

    @JvmStatic
    @NotNull
    public static final Name getScriptTargetClassName(@NotNull Name originalName) {
        Intrinsics.checkNotNullParameter((Object)originalName, (String)"originalName");
        return INSTANCE.getSnippetOrScriptTargetClassName(originalName, "script-");
    }

    @JvmStatic
    @NotNull
    public static final Name getSnippetTargetClassName(@NotNull Name originalName) {
        Intrinsics.checkNotNullParameter((Object)originalName, (String)"originalName");
        return INSTANCE.getSnippetOrScriptTargetClassName(originalName, "snippet-");
    }

    private final Name getSnippetOrScriptTargetClassName(Name originalName, String prefix) {
        Name name;
        if (originalName.isSpecial()) {
            String string = originalName.asStringStripSpecialMarkers();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asStringStripSpecialMarkers(...)");
            name = NameUtils.getScriptNameForFile(StringsKt.removePrefix((String)string, (CharSequence)prefix));
        } else {
            name = originalName;
        }
        return name;
    }

    @JvmStatic
    public static final boolean hasName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return !Intrinsics.areEqual((Object)name, (Object)SpecialNames.NO_NAME_PROVIDED) && !Intrinsics.areEqual((Object)name, (Object)SpecialNames.ANONYMOUS);
    }

    @JvmStatic
    @NotNull
    public static final Name delegateFieldName(int index) {
        Name name = Name.identifier("$$delegate_" + index);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return name;
    }

    @JvmStatic
    @NotNull
    public static final Name propertyDelegateName(@NotNull Name propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Name name = Name.identifier(propertyName.asString() + "$delegate");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return name;
    }

    @JvmStatic
    @NotNull
    public static final Name contextReceiverName(int index) {
        Name name = Name.identifier(CONTEXT_RECEIVER_PREFIX + '_' + index);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return name;
    }
}

