/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nClassId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassId.kt\norg/jetbrains/kotlin/name/ClassId\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,141:1\n1#2:142\n231#3:143\n231#3:144\n*S KotlinDebug\n*F\n+ 1 ClassId.kt\norg/jetbrains/kotlin/name/ClassId\n*L\n37#1:143\n47#1:144\n*E\n"})
public final class ClassId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName packageFqName;
    @NotNull
    private final FqName relativeClassName;
    private final boolean isLocal;

    public ClassId(@NotNull FqName packageFqName, @NotNull FqName relativeClassName, boolean isLocal) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)relativeClassName, (String)"relativeClassName");
        this.packageFqName = packageFqName;
        this.relativeClassName = relativeClassName;
        this.isLocal = isLocal;
        boolean bl2 = bl = !this.relativeClassName.isRoot();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Class name must not be root: " + this.packageFqName + (this.isLocal ? " (local)" : "");
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    @NotNull
    public final FqName getRelativeClassName() {
        return this.relativeClassName;
    }

    public final boolean isLocal() {
        return this.isLocal;
    }

    public ClassId(@NotNull FqName packageFqName, @NotNull Name topLevelName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)topLevelName, (String)"topLevelName");
        this(packageFqName, FqName.Companion.topLevel(topLevelName), false);
    }

    @Nullable
    public final ClassId getParentClassId() {
        ClassId classId;
        boolean condition$iv = this.isNestedClass();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            classId = new ClassId(this.packageFqName, this.relativeClassName.parent(), this.isLocal);
        } else {
            classId = null;
        }
        return classId;
    }

    @NotNull
    public final Name getShortClassName() {
        return this.relativeClassName.shortName();
    }

    @Nullable
    public final ClassId getOuterClassId() {
        ClassId classId;
        FqName parent = this.relativeClassName.parent();
        boolean condition$iv = !parent.isRoot();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            classId = new ClassId(this.packageFqName, parent, this.isLocal);
        } else {
            classId = null;
        }
        return classId;
    }

    @NotNull
    public final ClassId getOutermostClassId() {
        FqName name = this.relativeClassName;
        while (!name.parent().isRoot()) {
            name = name.parent();
        }
        return new ClassId(this.packageFqName, name, false);
    }

    public final boolean isNestedClass() {
        return !this.relativeClassName.parent().isRoot();
    }

    @NotNull
    public final ClassId createNestedClassId(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new ClassId(this.packageFqName, this.relativeClassName.child(name), this.isLocal);
    }

    @NotNull
    public final FqName asSingleFqName() {
        return this.packageFqName.isRoot() ? this.relativeClassName : new FqName(this.packageFqName.asString() + '.' + this.relativeClassName.asString());
    }

    public final boolean startsWith(@NotNull Name segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        return this.packageFqName.startsWith(segment);
    }

    @NotNull
    public final String asString() {
        String string;
        if (this.packageFqName.isRoot()) {
            string = ClassId.asString$escapeSlashes(this.relativeClassName);
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$asString_u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$asString_u24lambda_u243.append(StringsKt.replace$default((String)this.packageFqName.asString(), (char)'.', (char)'/', (boolean)false, (int)4, null));
            $this$asString_u24lambda_u243.append("/");
            $this$asString_u24lambda_u243.append(ClassId.asString$escapeSlashes(this.relativeClassName));
            string = stringBuilder.toString();
        }
        return string;
    }

    @NotNull
    public final String asFqNameString() {
        String string;
        if (this.packageFqName.isRoot()) {
            string = this.relativeClassName.asString();
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$asFqNameString_u24lambda_u244 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$asFqNameString_u24lambda_u244.append(this.packageFqName.asString());
            $this$asFqNameString_u24lambda_u244.append(".");
            $this$asFqNameString_u24lambda_u244.append(this.relativeClassName.asString());
            string = stringBuilder.toString();
        }
        return string;
    }

    @NotNull
    public String toString() {
        return this.packageFqName.isRoot() ? '/' + this.asString() : this.asString();
    }

    @NotNull
    public final FqName component1() {
        return this.packageFqName;
    }

    @NotNull
    public final FqName component2() {
        return this.relativeClassName;
    }

    public final boolean component3() {
        return this.isLocal;
    }

    @NotNull
    public final ClassId copy(@NotNull FqName packageFqName, @NotNull FqName relativeClassName, boolean isLocal) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)relativeClassName, (String)"relativeClassName");
        return new ClassId(packageFqName, relativeClassName, isLocal);
    }

    public static /* synthetic */ ClassId copy$default(ClassId classId, FqName fqName, FqName fqName2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            fqName = classId.packageFqName;
        }
        if ((n & 2) != 0) {
            fqName2 = classId.relativeClassName;
        }
        if ((n & 4) != 0) {
            bl = classId.isLocal;
        }
        return classId.copy(fqName, fqName2, bl);
    }

    public int hashCode() {
        int result = this.packageFqName.hashCode();
        result = result * 31 + this.relativeClassName.hashCode();
        result = result * 31 + Boolean.hashCode(this.isLocal);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClassId)) {
            return false;
        }
        ClassId classId = (ClassId)other;
        if (!Intrinsics.areEqual((Object)this.packageFqName, (Object)classId.packageFqName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.relativeClassName, (Object)classId.relativeClassName)) {
            return false;
        }
        return this.isLocal == classId.isLocal;
    }

    private static final String asString$escapeSlashes(FqName $this$asString_u24escapeSlashes) {
        String res = $this$asString_u24escapeSlashes.asString();
        if (StringsKt.contains$default((CharSequence)res, (char)'/', (boolean)false, (int)2, null)) {
            return '`' + res + '`';
        }
        return res;
    }

    @JvmStatic
    @NotNull
    public static final ClassId topLevel(@NotNull FqName topLevelFqName) {
        return Companion.topLevel(topLevelFqName);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ClassId fromString(@NotNull String string, boolean isLocal) {
        return Companion.fromString(string, isLocal);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ClassId fromString(@NotNull String string) {
        return Companion.fromString(string);
    }

    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ClassId topLevel(@NotNull FqName topLevelFqName) {
            Intrinsics.checkNotNullParameter((Object)topLevelFqName, (String)"topLevelFqName");
            return new ClassId(topLevelFqName.parent(), topLevelFqName.shortName());
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ClassId fromString(@NotNull String string, boolean isLocal) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            int tickIndex = StringsKt.indexOf$default((CharSequence)string, (char)'`', (int)0, (boolean)false, (int)6, null);
            int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)string, (String)"/", (int)(tickIndex == -1 ? string.length() : tickIndex), (boolean)false, (int)4, null);
            String packageName = null;
            String className = null;
            if (lastSlashIndex == -1) {
                packageName = "";
                className = StringsKt.replace$default((String)string, (String)"`", (String)"", (boolean)false, (int)4, null);
            } else {
                String string2 = string.substring(0, lastSlashIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                packageName = StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
                String string3 = string.substring(lastSlashIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                className = StringsKt.replace$default((String)string3, (String)"`", (String)"", (boolean)false, (int)4, null);
            }
            return new ClassId(new FqName(packageName), new FqName(className), isLocal);
        }

        public static /* synthetic */ ClassId fromString$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.fromString(string, bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ClassId fromString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return kotlin.reflect.jvm.internal.impl.name.ClassId$Companion.fromString$default(this, string, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

