/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.builtins.BuiltInsProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.MetadataVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolverImpl;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionSpecificBehaviorKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmModuleProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.BinaryModuleData;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ModuleMappingKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.PackageParts;
import kotlin.reflect.jvm.internal.impl.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.protobuf.ProtocolStringList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleMapping {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetadataVersion version;
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    @NotNull
    private final BinaryModuleData moduleData;
    @NotNull
    private final String debugName;
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY = new ModuleMapping(MetadataVersion.INSTANCE, MapsKt.emptyMap(), kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ModuleMapping$Companion.access$emptyBinaryData(Companion), "EMPTY");
    @JvmField
    @NotNull
    public static final ModuleMapping CORRUPTED = new ModuleMapping(MetadataVersion.INSTANCE, MapsKt.emptyMap(), kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ModuleMapping$Companion.access$emptyBinaryData(Companion), "CORRUPTED");
    public static final int STRICT_METADATA_VERSION_SEMANTICS_FLAG = 1;

    private ModuleMapping(MetadataVersion version, Map<String, PackageParts> packageFqName2Parts, BinaryModuleData moduleData, String debugName) {
        this.version = version;
        this.packageFqName2Parts = packageFqName2Parts;
        this.moduleData = moduleData;
        this.debugName = debugName;
    }

    @NotNull
    public final MetadataVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final Map<String, PackageParts> getPackageFqName2Parts() {
        return this.packageFqName2Parts;
    }

    @NotNull
    public final BinaryModuleData getModuleData() {
        return this.moduleData;
    }

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    public /* synthetic */ ModuleMapping(MetadataVersion version, Map packageFqName2Parts, BinaryModuleData moduleData, String debugName, DefaultConstructorMarker $constructor_marker) {
        this(version, packageFqName2Parts, moduleData, debugName);
    }

    @SourceDebugExtension(value={"SMAP\nModuleMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapping.kt\norg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,303:1\n1#2:304\n384#3,7:305\n384#3,7:312\n1869#4,2:319\n1563#4:321\n1634#4,3:322\n*S KotlinDebug\n*F\n+ 1 ModuleMapping.kt\norg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping$Companion\n*L\n89#1:305,7\n121#1:312,7\n122#1:319,2\n127#1:321\n127#1:322,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final int[] readVersionNumber(@NotNull DataInputStream stream) {
            int[] nArray;
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            try {
                int[] nArray2;
                int size = stream.readInt();
                if (size < 0 || size > 1024) {
                    nArray2 = null;
                } else {
                    int n = 0;
                    int[] nArray3 = new int[size];
                    while (n < size) {
                        int n2 = n++;
                        nArray3[n2] = stream.readInt();
                    }
                    nArray2 = nArray3;
                }
                nArray = nArray2;
            }
            catch (IOException e) {
                nArray = null;
            }
            return nArray;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping loadModuleMapping(@Nullable byte[] bytes, @NotNull String debugName, boolean skipMetadataVersionCheck, boolean isJvmPackageNameSupported, @NotNull MetadataVersion metadataVersionFromLanguageVersion, @NotNull Function1<? super MetadataVersion, Unit> reportIncompatibleVersionError) {
            void $this$mapTo$iv$iv;
            ProtoBuf.Annotation jvmPackageName;
            Object packageParts;
            PackageParts answer$iv;
            Object value$iv;
            ExtensionRegistryLite extensionRegistryLite;
            Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
            Intrinsics.checkNotNullParameter((Object)metadataVersionFromLanguageVersion, (String)"metadataVersionFromLanguageVersion");
            Intrinsics.checkNotNullParameter(reportIncompatibleVersionError, (String)"reportIncompatibleVersionError");
            if (bytes == null) {
                return EMPTY;
            }
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
            int[] nArray = this.readVersionNumber(stream);
            if (nArray == null) {
                return CORRUPTED;
            }
            int[] versionNumber = nArray;
            MetadataVersion preVersion = new MetadataVersion(Arrays.copyOf(versionNumber, versionNumber.length));
            if (!skipMetadataVersionCheck && !preVersion.isCompatible(metadataVersionFromLanguageVersion)) {
                reportIncompatibleVersionError.invoke((Object)preVersion);
                return EMPTY;
            }
            int flags = VersionSpecificBehaviorKt.isKotlin1Dot4OrLater(preVersion) ? stream.readInt() : 0;
            MetadataVersion version = new MetadataVersion(versionNumber, (flags & 1) != 0);
            if (!skipMetadataVersionCheck && !version.isCompatible(metadataVersionFromLanguageVersion)) {
                reportIncompatibleVersionError.invoke((Object)version);
                return EMPTY;
            }
            ExtensionRegistryLite p0 = extensionRegistryLite = ExtensionRegistryLite.newInstance();
            boolean bl = false;
            BuiltInsProtoBuf.registerAllExtensions(p0);
            ExtensionRegistryLite extensions = extensionRegistryLite;
            JvmModuleProtoBuf.Module module = JvmModuleProtoBuf.Module.parseFrom(stream, extensions);
            if (module == null) {
                return EMPTY;
            }
            JvmModuleProtoBuf.Module moduleProto = module;
            LinkedHashMap result = new LinkedHashMap();
            for (JvmModuleProtoBuf.PackageParts proto : moduleProto.getPackagePartsList()) {
                String partShortName;
                Object object;
                String packageFqName = proto.getPackageFqName();
                Iterator $this$getOrPut$iv = result;
                int $i$f$getOrPut = 0;
                value$iv = $this$getOrPut$iv.get(packageFqName);
                if (value$iv == null) {
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)packageFqName);
                    answer$iv = new PackageParts(packageFqName);
                    $this$getOrPut$iv.put(packageFqName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                packageParts = (PackageParts)object;
                $this$getOrPut$iv = ((Iterable)proto.getShortClassNameList()).iterator();
                $i$f$getOrPut = 0;
                while ($this$getOrPut$iv.hasNext()) {
                    int index = $i$f$getOrPut++;
                    partShortName = (String)$this$getOrPut$iv.next();
                    Intrinsics.checkNotNull((Object)packageFqName);
                    Intrinsics.checkNotNull((Object)partShortName);
                    String string = ModuleMappingKt.access$internalNameOf(packageFqName, partShortName);
                    List<Integer> list = proto.getMultifileFacadeShortNameIdList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getMultifileFacadeShortNameIdList(...)");
                    ProtocolStringList protocolStringList = proto.getMultifileFacadeShortNameList();
                    Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getMultifileFacadeShortNameList(...)");
                    ((PackageParts)packageParts).addPart(string, this.loadMultiFileFacadeInternalName(list, protocolStringList, index, packageFqName));
                }
                if (!isJvmPackageNameSupported) continue;
                $this$getOrPut$iv = ((Iterable)proto.getClassWithJvmPackageNameShortNameList()).iterator();
                $i$f$getOrPut = 0;
                while ($this$getOrPut$iv.hasNext()) {
                    int n;
                    int index = $i$f$getOrPut++;
                    partShortName = (String)$this$getOrPut$iv.next();
                    List<Integer> list = proto.getClassWithJvmPackageNamePackageIdList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getClassWithJvmPackageNamePackageIdList(...)");
                    Integer n2 = (Integer)CollectionsKt.getOrNull(list, (int)index);
                    if (n2 != null) {
                        n = n2;
                    } else {
                        List<Integer> list2 = proto.getClassWithJvmPackageNamePackageIdList();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"getClassWithJvmPackageNamePackageIdList(...)");
                        Integer n3 = (Integer)CollectionsKt.lastOrNull(list2);
                        if (n3 == null) continue;
                        n = n3;
                    }
                    int packageId = n;
                    ProtocolStringList protocolStringList = moduleProto.getJvmPackageNameList();
                    Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getJvmPackageNameList(...)");
                    if ((String)CollectionsKt.getOrNull((List)protocolStringList, (int)packageId) == null) continue;
                    Intrinsics.checkNotNull((Object)partShortName);
                    String string = ModuleMappingKt.access$internalNameOf((String)((Object)jvmPackageName), partShortName);
                    List<Integer> list3 = proto.getClassWithJvmPackageNameMultifileFacadeShortNameIdList();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"getClassWithJvmPackageNa\u2026acadeShortNameIdList(...)");
                    ProtocolStringList protocolStringList2 = proto.getMultifileFacadeShortNameList();
                    Intrinsics.checkNotNullExpressionValue((Object)protocolStringList2, (String)"getMultifileFacadeShortNameList(...)");
                    ((PackageParts)packageParts).addPart(string, this.loadMultiFileFacadeInternalName(list3, protocolStringList2, index, (String)((Object)jvmPackageName)));
                }
            }
            for (JvmModuleProtoBuf.PackageParts proto : moduleProto.getMetadataPartsList()) {
                Object object;
                void $this$getOrPut$iv;
                packageParts = result;
                String key$iv = proto.getPackageFqName();
                boolean $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    String string = proto.getPackageFqName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageFqName(...)");
                    answer$iv = new PackageParts(string);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                PackageParts packageParts2 = (PackageParts)object;
                ProtocolStringList protocolStringList = proto.getShortClassNameList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getShortClassNameList(...)");
                Iterable $this$forEach$iv = protocolStringList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String p02 = (String)element$iv;
                    boolean bl4 = false;
                    packageParts2.addMetadataPart(p02);
                }
            }
            ProtoBuf.StringTable stringTable = moduleProto.getStringTable();
            Intrinsics.checkNotNullExpressionValue((Object)stringTable, (String)"getStringTable(...)");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = moduleProto.getQualifiedNameTable();
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"getQualifiedNameTable(...)");
            NameResolverImpl nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
            List<ProtoBuf.Annotation> list = moduleProto.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable $i$f$forEach = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void proto;
                jvmPackageName = (ProtoBuf.Annotation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(nameResolver.getQualifiedClassName(proto.getId()));
            }
            List annotations = (List)destination$iv$iv;
            Map map = result;
            List<ProtoBuf.Class> list4 = moduleProto.getOptionalAnnotationClassList();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getOptionalAnnotationClassList(...)");
            return new ModuleMapping(version, map, new BinaryModuleData(annotations, list4, nameResolver), debugName, null);
        }

        public static /* synthetic */ ModuleMapping loadModuleMapping$default(Companion companion, byte[] byArray, String string, boolean bl, boolean bl2, MetadataVersion metadataVersion, Function1 function1, int n, Object object) {
            if ((n & 0x10) != 0) {
                metadataVersion = MetadataVersion.INSTANCE;
            }
            return companion.loadModuleMapping(byArray, string, bl, bl2, metadataVersion, (Function1<? super MetadataVersion, Unit>)function1);
        }

        private final String loadMultiFileFacadeInternalName(List<Integer> multifileFacadeIds, List<String> multifileFacadeShortNames, int index, String packageFqName) {
            String string;
            String facadeShortName;
            String string2;
            Integer multifileFacadeId;
            Integer n = (Integer)CollectionsKt.getOrNull(multifileFacadeIds, (int)index);
            Integer n2 = multifileFacadeId = n != null ? Integer.valueOf(n - 1) : null;
            if (n2 != null) {
                int p0 = ((Number)n2).intValue();
                boolean bl = false;
                string2 = (String)CollectionsKt.getOrNull(multifileFacadeShortNames, (int)p0);
            } else {
                string2 = null;
            }
            String string3 = facadeShortName = string2;
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                string = ModuleMappingKt.access$internalNameOf(packageFqName, it);
            } else {
                string = null;
            }
            return string;
        }

        private final BinaryModuleData emptyBinaryData() {
            List list = CollectionsKt.emptyList();
            List list2 = CollectionsKt.emptyList();
            ProtoBuf.StringTable stringTable = ProtoBuf.StringTable.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)stringTable, (String)"getDefaultInstance(...)");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = ProtoBuf.QualifiedNameTable.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"getDefaultInstance(...)");
            return new BinaryModuleData(list, list2, new NameResolverImpl(stringTable, qualifiedNameTable));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ BinaryModuleData access$emptyBinaryData(Companion $this) {
            return $this.emptyBinaryData();
        }
    }
}

