/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PackagePartProvider {
    @NotNull
    public List<String> findPackageParts(@NotNull String var1);

    @Nullable
    public Set<String> computePackageSetWithNonClassDeclarations();

    @NotNull
    public List<ClassId> getAnnotationsOnBinaryModule(@NotNull String var1);

    @NotNull
    public List<ClassData> getAllOptionalAnnotationClasses();

    public boolean mayHaveOptionalAnnotationClasses();

    public static final class Empty
    implements PackagePartProvider {
        @NotNull
        public static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        @NotNull
        public List<String> findPackageParts(@NotNull String packageFqName) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public List<ClassId> getAnnotationsOnBinaryModule(@NotNull String moduleName) {
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public List<ClassData> getAllOptionalAnnotationClasses() {
            return CollectionsKt.emptyList();
        }

        @Override
        public boolean mayHaveOptionalAnnotationClasses() {
            return false;
        }

        @Override
        @NotNull
        public Set<String> computePackageSetWithNonClassDeclarations() {
            return SetsKt.emptySet();
        }
    }
}

