/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinSpecialProperties;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAbi;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\npropertiesConventionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 propertiesConventionUtil.kt\norg/jetbrains/kotlin/load/java/PropertiesConventionUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n774#2:103\n865#2,2:104\n*S KotlinDebug\n*F\n+ 1 propertiesConventionUtil.kt\norg/jetbrains/kotlin/load/java/PropertiesConventionUtilKt\n*L\n90#1:103\n90#1:104,2\n*E\n"})
public final class PropertiesConventionUtilKt {
    @Nullable
    public static final Name propertyNameByGetMethodName(@NotNull Name methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Name name = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "get", false, null, 12, null);
        if (name == null) {
            name = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "is", false, null, 8, null);
        }
        return name;
    }

    @Nullable
    public static final Name propertyNameBySetMethodName(@NotNull Name methodName, boolean withIsPrefix) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "set", false, withIsPrefix ? "is" : null, 4, null);
    }

    @NotNull
    public static final List<Name> propertyNamesBySetMethodName(@NotNull Name methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Object[] objectArray = new Name[]{PropertiesConventionUtilKt.propertyNameBySetMethodName(methodName, false), PropertiesConventionUtilKt.propertyNameBySetMethodName(methodName, true)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @NotNull
    public static final List<Name> propertyNamesByAccessorName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object[] objectArray = new Name[]{PropertiesConventionUtilKt.propertyNameByGetMethodName(name), PropertiesConventionUtilKt.propertyNameBySetMethodName(name, true), PropertiesConventionUtilKt.propertyNameBySetMethodName(name, false)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private static final Name propertyNameFromAccessorMethodName(Name methodName, String prefix, boolean removePrefix, String addPrefix) {
        if (methodName.isSpecial()) {
            return null;
        }
        String string = methodName.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
        String identifier = string;
        if (!StringsKt.startsWith$default((String)identifier, (String)prefix, (boolean)false, (int)2, null)) {
            return null;
        }
        if (identifier.length() == prefix.length()) {
            return null;
        }
        char c = identifier.charAt(prefix.length());
        boolean bl = 'a' <= c ? c < '{' : false;
        if (bl) {
            return null;
        }
        if (addPrefix != null) {
            if (_Assertions.ENABLED && !removePrefix) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return Name.identifier(addPrefix + StringsKt.removePrefix((String)identifier, (CharSequence)prefix));
        }
        if (!removePrefix) {
            return methodName;
        }
        String name = CapitalizeDecapitalizeKt.decapitalizeSmartForCompiler(StringsKt.removePrefix((String)identifier, (CharSequence)prefix), true);
        if (!Name.isValidIdentifier(name)) {
            return null;
        }
        return Name.identifier(name);
    }

    static /* synthetic */ Name propertyNameFromAccessorMethodName$default(Name name, String string, boolean bl, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName(name, string, bl, string2);
    }

    @NotNull
    public static final List<Name> getPropertyNamesCandidatesByAccessorName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String nameAsString = string;
        if (JvmAbi.isGetterName(nameAsString)) {
            return CollectionsKt.listOfNotNull((Object)PropertiesConventionUtilKt.propertyNameByGetMethodName(name));
        }
        if (JvmAbi.isSetterName(nameAsString)) {
            return PropertiesConventionUtilKt.propertyNamesBySetMethodName(name);
        }
        return BuiltinSpecialProperties.INSTANCE.getPropertyNameCandidatesBySpecialGetterName(name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Name> possibleGetMethodNames(@NotNull Name propertyName) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String identifier;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
                if (propertyName.isSpecial()) {
                    return CollectionsKt.emptyList();
                }
                String string = propertyName.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
                identifier = string;
                if (((CharSequence)identifier).length() == 0) {
                    return CollectionsKt.emptyList();
                }
                char firstChar = identifier.charAt(0);
                if (!Character.isJavaIdentifierStart(firstChar)) break block8;
                boolean bl = 'A' <= firstChar ? firstChar < '[' : false;
                if (!bl) break block9;
            }
            return CollectionsKt.emptyList();
        }
        ArrayList<Name> result = new ArrayList<Name>(3);
        if (JvmAbi.startsWithIsPrefix(identifier)) {
            result.add(propertyName);
        }
        String capitalize1 = CapitalizeDecapitalizeKt.capitalizeAsciiOnly(identifier);
        String capitalize2 = CapitalizeDecapitalizeKt.capitalizeFirstWord(identifier, true);
        result.add(Name.identifier("get" + capitalize1));
        if (!Intrinsics.areEqual((Object)capitalize2, (Object)capitalize1)) {
            result.add(Name.identifier("get" + capitalize2));
        }
        Iterable iterable = result;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Name it = (Name)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)PropertiesConventionUtilKt.propertyNameByGetMethodName(it), (Object)propertyName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Name setMethodName(@NotNull Name getMethodName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)getMethodName, (String)"getMethodName");
        String string2 = getMethodName.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
        String identifier = string2;
        if (StringsKt.startsWith$default((String)identifier, (String)"get", (boolean)false, (int)2, null)) {
            string = "get";
        } else if (StringsKt.startsWith$default((String)identifier, (String)"is", (boolean)false, (int)2, null)) {
            string = "is";
        } else {
            throw new IllegalArgumentException();
        }
        String prefix = string;
        Name name = Name.identifier("set" + StringsKt.removePrefix((String)identifier, (CharSequence)prefix));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return name;
    }
}

