/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.NullabilityAnnotationStates;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt;
import kotlin.reflect.jvm.internal.impl.storage.LockBasedStorageManager;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNullable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NullabilityAnnotationStatesImpl<T>
implements NullabilityAnnotationStates<T> {
    @NotNull
    private final Map<FqName, T> states;
    @NotNull
    private final LockBasedStorageManager storageManager;
    @NotNull
    private final MemoizedFunctionToNullable<FqName, T> cache;

    public NullabilityAnnotationStatesImpl(@NotNull Map<FqName, ? extends T> states) {
        Intrinsics.checkNotNullParameter(states, (String)"states");
        this.states = states;
        this.storageManager = new LockBasedStorageManager("Java nullability annotation states");
        MemoizedFunctionToNullable memoizedFunctionToNullable = this.storageManager.createMemoizedFunctionWithNullableValues(arg_0 -> NullabilityAnnotationStatesImpl.cache$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(memoizedFunctionToNullable, (String)"createMemoizedFunctionWithNullableValues(...)");
        this.cache = memoizedFunctionToNullable;
    }

    @NotNull
    public final Map<FqName, T> getStates() {
        return this.states;
    }

    @NotNull
    public final LockBasedStorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    @Nullable
    public T get(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return (T)this.cache.invoke(fqName);
    }

    private static final Object cache$lambda$0(NullabilityAnnotationStatesImpl this$0, FqName it) {
        Intrinsics.checkNotNull((Object)it);
        return FqNamesUtilKt.findValueForMostSpecificFqname(it, this$0.states);
    }
}

