/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class JvmAbi {
    @NotNull
    public static final JvmAbi INSTANCE = new JvmAbi();
    @NotNull
    public static final String DEFAULT_IMPLS_CLASS_NAME = "DefaultImpls";
    @NotNull
    public static final String ERASED_INLINE_CONSTRUCTOR_NAME = "constructor";
    @JvmField
    @NotNull
    public static final FqName JVM_FIELD_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmField");
    @JvmField
    @NotNull
    public static final ClassId JVM_FIELD_ANNOTATION_CLASS_ID = ClassId.Companion.topLevel(JVM_FIELD_ANNOTATION_FQ_NAME);
    @NotNull
    public static final String DEFAULT_IMPLS_SUFFIX = "$DefaultImpls";
    @NotNull
    public static final String DEFAULT_PARAMS_IMPL_SUFFIX = "$default";
    @NotNull
    private static final String GET_PREFIX = "get";
    @NotNull
    private static final String IS_PREFIX = "is";
    @NotNull
    private static final String SET_PREFIX = "set";
    @NotNull
    public static final String DELEGATED_PROPERTY_NAME_SUFFIX = "$delegate";
    @NotNull
    public static final String DELEGATED_PROPERTIES_ARRAY_NAME = "$$delegatedProperties";
    @NotNull
    public static final String DELEGATE_SUPER_FIELD_PREFIX = "$$delegate_";
    @NotNull
    private static final String ANNOTATIONS_SUFFIX = "$annotations";
    @NotNull
    public static final String ANNOTATED_PROPERTY_METHOD_NAME_SUFFIX = "$annotations";
    @NotNull
    private static final String ANNOTATED_TYPEALIAS_METHOD_NAME_SUFFIX = "$annotations";
    @NotNull
    public static final String INSTANCE_FIELD = "INSTANCE";
    @NotNull
    public static final String HIDDEN_INSTANCE_FIELD = "$$INSTANCE";
    @NotNull
    private static final ClassId REFLECTION_FACTORY_IMPL = ClassId.Companion.topLevel(new FqName("kotlin.reflect.jvm.internal.ReflectionFactoryImpl"));
    @NotNull
    public static final String LOCAL_VARIABLE_NAME_PREFIX_INLINE_ARGUMENT = "$i$a$";
    @NotNull
    public static final String LOCAL_VARIABLE_NAME_PREFIX_INLINE_FUNCTION = "$i$f$";
    @NotNull
    public static final String IMPL_SUFFIX_FOR_INLINE_CLASS_MEMBERS = "-impl";
    @NotNull
    public static final String REPEATABLE_ANNOTATION_CONTAINER_NAME = "Container";
    @NotNull
    private static final ClassId REPEATABLE_ANNOTATION_CONTAINER_META_ANNOTATION = ClassId.Companion.fromString$default(ClassId.Companion, "kotlin/jvm/internal/RepeatableContainer", false, 2, null);

    private JvmAbi() {
    }

    @NotNull
    public final ClassId getREFLECTION_FACTORY_IMPL() {
        return REFLECTION_FACTORY_IMPL;
    }

    @NotNull
    public final ClassId getREPEATABLE_ANNOTATION_CONTAINER_META_ANNOTATION() {
        return REPEATABLE_ANNOTATION_CONTAINER_META_ANNOTATION;
    }

    @JvmStatic
    @NotNull
    public static final String getSyntheticMethodNameForAnnotatedProperty(@NotNull String baseName) {
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        return baseName + "$annotations";
    }

    @JvmStatic
    @NotNull
    public static final String getSyntheticMethodNameForAnnotatedTypeAlias(@NotNull Name typeAliasName) {
        Intrinsics.checkNotNullParameter((Object)typeAliasName, (String)"typeAliasName");
        return typeAliasName.asString() + "$annotations";
    }

    @JvmStatic
    public static final boolean isGetterName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.startsWith$default((String)name, (String)GET_PREFIX, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)IS_PREFIX, (boolean)false, (int)2, null);
    }

    @JvmStatic
    public static final boolean isSetterName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.startsWith$default((String)name, (String)SET_PREFIX, (boolean)false, (int)2, null);
    }

    @JvmStatic
    @NotNull
    public static final String getterName(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return JvmAbi.startsWithIsPrefix(propertyName) ? propertyName : GET_PREFIX + CapitalizeDecapitalizeKt.capitalizeAsciiOnly(propertyName);
    }

    @JvmStatic
    @NotNull
    public static final String setterName(@NotNull String propertyName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        StringBuilder stringBuilder = new StringBuilder().append(SET_PREFIX);
        if (JvmAbi.startsWithIsPrefix(propertyName)) {
            String string2 = propertyName.substring(2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = CapitalizeDecapitalizeKt.capitalizeAsciiOnly(propertyName);
        }
        return stringBuilder.append(string).toString();
    }

    @JvmStatic
    public static final boolean startsWithIsPrefix(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!StringsKt.startsWith$default((String)name, (String)IS_PREFIX, (boolean)false, (int)2, null)) {
            return false;
        }
        if (name.length() == 2) {
            return false;
        }
        char c = name.charAt(2);
        return Intrinsics.compare((int)97, (int)c) > 0 || Intrinsics.compare((int)c, (int)122) > 0;
    }

    @JvmStatic
    public static final boolean isFakeLocalVariableForInline(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.startsWith$default((String)name, (String)LOCAL_VARIABLE_NAME_PREFIX_INLINE_FUNCTION, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)LOCAL_VARIABLE_NAME_PREFIX_INLINE_ARGUMENT, (boolean)false, (int)2, null);
    }
}

