/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPackage;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JavaClassFinder {
    @Nullable
    public JavaClass findClass(@NotNull Request var1);

    @Nullable
    default public JavaClass findClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.findClass(new Request(classId, null, null, 6, null));
    }

    @NotNull
    public List<JavaClass> findClasses(@NotNull Request var1);

    @NotNull
    default public List<JavaClass> findClasses(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.findClasses(new Request(classId, null, null, 6, null));
    }

    @Nullable
    public JavaPackage findPackage(@NotNull FqName var1, boolean var2);

    public static /* synthetic */ JavaPackage findPackage$default(JavaClassFinder javaClassFinder, FqName fqName, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findPackage");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return javaClassFinder.findPackage(fqName, bl);
    }

    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName var1);

    public boolean canComputeKnownClassNamesInPackage();

    public static final class Request {
        @NotNull
        private final ClassId classId;
        @Nullable
        private final byte[] previouslyFoundClassFileContent;
        @Nullable
        private final JavaClass outerClass;

        public Request(@NotNull ClassId classId, @Nullable byte[] previouslyFoundClassFileContent, @Nullable JavaClass outerClass) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            this.classId = classId;
            this.previouslyFoundClassFileContent = previouslyFoundClassFileContent;
            this.outerClass = outerClass;
        }

        public /* synthetic */ Request(ClassId classId, byte[] byArray, JavaClass javaClass, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                byArray = null;
            }
            if ((n & 4) != 0) {
                javaClass = null;
            }
            this(classId, byArray, javaClass);
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Nullable
        public final byte[] getPreviouslyFoundClassFileContent() {
            return this.previouslyFoundClassFileContent;
        }

        @Nullable
        public final JavaClass getOuterClass() {
            return this.outerClass;
        }

        @NotNull
        public final ClassId component1() {
            return this.classId;
        }

        @Nullable
        public final byte[] component2() {
            return this.previouslyFoundClassFileContent;
        }

        @Nullable
        public final JavaClass component3() {
            return this.outerClass;
        }

        @NotNull
        public final Request copy(@NotNull ClassId classId, @Nullable byte[] previouslyFoundClassFileContent, @Nullable JavaClass outerClass) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            return new Request(classId, previouslyFoundClassFileContent, outerClass);
        }

        public static /* synthetic */ Request copy$default(Request request, ClassId classId, byte[] byArray, JavaClass javaClass, int n, Object object) {
            if ((n & 1) != 0) {
                classId = request.classId;
            }
            if ((n & 2) != 0) {
                byArray = request.previouslyFoundClassFileContent;
            }
            if ((n & 4) != 0) {
                javaClass = request.outerClass;
            }
            return request.copy(classId, byArray, javaClass);
        }

        @NotNull
        public String toString() {
            return "Request(classId=" + this.classId + ", previouslyFoundClassFileContent=" + Arrays.toString(this.previouslyFoundClassFileContent) + ", outerClass=" + this.outerClass + ')';
        }

        public int hashCode() {
            int result = this.classId.hashCode();
            result = result * 31 + (this.previouslyFoundClassFileContent == null ? 0 : Arrays.hashCode(this.previouslyFoundClassFileContent));
            result = result * 31 + (this.outerClass == null ? 0 : this.outerClass.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Request)) {
                return false;
            }
            Request request = (Request)other;
            if (!Intrinsics.areEqual((Object)this.classId, (Object)request.classId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.previouslyFoundClassFileContent, (Object)request.previouslyFoundClassFileContent)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.outerClass, (Object)request.outerClass);
        }
    }
}

