/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.km.jvm.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.km.InconsistentKotlinMetadataException;
import kotlin.reflect.jvm.internal.impl.km.KmClass;
import kotlin.reflect.jvm.internal.impl.km.KmLambda;
import kotlin.reflect.jvm.internal.impl.km.KmPackage;
import kotlin.reflect.jvm.internal.impl.km.internal.ReadersKt;
import kotlin.reflect.jvm.internal.impl.km.jvm.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.km.jvm.KmModule;
import kotlin.reflect.jvm.internal.impl.km.jvm.KmPackageParts;
import kotlin.reflect.jvm.internal.impl.km.jvm.KotlinClassMetadata;
import kotlin.reflect.jvm.internal.impl.km.jvm.UnstableMetadataApi;
import kotlin.reflect.jvm.internal.impl.km.jvm.internal.JvmExceptionUtilsKt;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.MetadataVersion;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmNameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmProtoBufUtil;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ModuleMapping;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nJvmReadUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmReadUtils.kt\nkotlin/metadata/jvm/internal/JvmReadUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 JvmExceptionUtils.kt\nkotlin/metadata/jvm/internal/JvmExceptionUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1#2:100\n15#3,8:101\n3303#4,10:109\n1285#4,2:119\n1299#4,4:121\n*S KotlinDebug\n*F\n+ 1 JvmReadUtils.kt\nkotlin/metadata/jvm/internal/JvmReadUtils\n*L\n48#1:101,8\n64#1:109,10\n67#1:119,2\n67#1:121,4\n*E\n"})
public final class JvmReadUtils {
    @NotNull
    public static final JvmReadUtils INSTANCE = new JvmReadUtils();

    private JvmReadUtils() {
    }

    private final boolean isLessThan14(Metadata annotationData) {
        return new JvmMetadataVersion(annotationData.mv()).compareTo(new JvmMetadataVersion(1, 4, 0)) < 0;
    }

    @NotNull
    public final KmClass readKmClass$kotlin_metadata_jvm(@NotNull Metadata annotationData) {
        Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
        Pair<JvmNameResolver, ProtoBuf.Class> pair = JvmProtoBufUtil.readClassDataFrom(JvmExceptionUtilsKt.requireNotEmpty(annotationData), annotationData.d2());
        JvmNameResolver strings = (JvmNameResolver)pair.component1();
        ProtoBuf.Class proto = (ProtoBuf.Class)pair.component2();
        return ReadersKt.toKmClass$default(proto, strings, this.isLessThan14(annotationData), null, 4, null);
    }

    @NotNull
    public final KmPackage readKmPackage$kotlin_metadata_jvm(@NotNull Metadata annotationData) {
        Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
        Pair<JvmNameResolver, ProtoBuf.Package> pair = JvmProtoBufUtil.readPackageDataFrom(JvmExceptionUtilsKt.requireNotEmpty(annotationData), annotationData.d2());
        JvmNameResolver strings = (JvmNameResolver)pair.component1();
        ProtoBuf.Package proto = (ProtoBuf.Package)pair.component2();
        return ReadersKt.toKmPackage$default(proto, strings, this.isLessThan14(annotationData), null, 4, null);
    }

    @Nullable
    public final KmLambda readKmLambda$kotlin_metadata_jvm(@NotNull Metadata annotationData) {
        Object object;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
                Pair<JvmNameResolver, ProtoBuf.Function> pair = annotationData.d1();
                Object[] p0 = (Object[])pair;
                boolean bl = false;
                object = !(p0.length == 0) ? pair : null;
                if (object == null) break block3;
                Pair<JvmNameResolver, ProtoBuf.Function> data1 = object;
                boolean bl2 = false;
                Pair<JvmNameResolver, ProtoBuf.Function> pair2 = JvmProtoBufUtil.readFunctionDataFrom((String[])data1, annotationData.d2());
                object = pair2;
                if (pair2 != null) break block4;
            }
            return null;
        }
        Pair<JvmNameResolver, ProtoBuf.Function> functionData = object;
        JvmNameResolver strings = (JvmNameResolver)functionData.component1();
        ProtoBuf.Function proto = (ProtoBuf.Function)functionData.component2();
        return ReadersKt.toKmLambda(proto, strings, this.isLessThan14(annotationData));
    }

    @NotNull
    public final KotlinClassMetadata readMetadataImpl$kotlin_metadata_jvm(@NotNull Metadata annotationData, boolean lenient) {
        KotlinClassMetadata kotlinClassMetadata;
        Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
        this.checkMetadataVersionForRead(annotationData, lenient);
        boolean $i$f$wrapIntoMetadataExceptionWhenNeeded = false;
        try {
            KotlinClassMetadata kotlinClassMetadata2;
            boolean bl = false;
            switch (annotationData.k()) {
                case 1: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.Class(annotationData, lenient);
                    break;
                }
                case 2: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.FileFacade(annotationData, lenient);
                    break;
                }
                case 3: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.SyntheticClass(annotationData, lenient);
                    break;
                }
                case 4: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.MultiFileClassFacade(annotationData, lenient);
                    break;
                }
                case 5: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.MultiFileClassPart(annotationData, lenient);
                    break;
                }
                default: {
                    kotlinClassMetadata2 = new KotlinClassMetadata.Unknown(annotationData, lenient);
                }
            }
            kotlinClassMetadata = kotlinClassMetadata2;
        }
        catch (Throwable e$iv) {
            Throwable throwable = e$iv;
            throw throwable instanceof IllegalArgumentException ? e$iv : (throwable instanceof VirtualMachineError || throwable instanceof ThreadDeath ? e$iv : (Throwable)new InconsistentKotlinMetadataException("Exception occurred when reading Kotlin metadata", e$iv));
        }
        return kotlinClassMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @UnstableMetadataApi
    @NotNull
    public final KmModule readModuleMetadataImpl$kotlin_metadata_jvm(@NotNull ModuleMapping data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KmModule v = new KmModule();
        for (Map.Entry<String, PackageParts> entry : data.getPackageFqName2Parts().entrySet()) {
            void $this$associateWith$iv;
            String fqName = entry.getKey();
            PackageParts parts = entry.getValue();
            Iterable $this$partition$iv = parts.getParts();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            Iterable<Object> second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = parts.getMultifileFacadeName(it) == null ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List fileFacades = (List)pair.component1();
            List multiFileClassParts = (List)pair.component2();
            Map<String, KmPackageParts> map = v.getPackageParts();
            second$iv = multiFileClassParts;
            List list = CollectionsKt.toMutableList((Collection)fileFacades);
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string;
                void it;
                String string2 = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)parts.getMultifileFacadeName((String)it));
                map2.put(t, string);
            }
            Map map3 = MapsKt.toMutableMap((Map)result$iv);
            List list2 = list;
            KmPackageParts kmPackageParts = new KmPackageParts(list2, map3);
            map.put(fqName, kmPackageParts);
        }
        for (ProtoBuf.Class classProto : data.getModuleData().getOptionalAnnotations()) {
            v.getOptionalAnnotationClasses().add(ReadersKt.toKmClass$default(classProto, data.getModuleData().getNameResolver(), false, null, 4, null));
        }
        return v;
    }

    private final void checkMetadataVersionForRead(Metadata annotationData, boolean lenient) {
        if (annotationData.mv().length == 0) {
            throw new IllegalArgumentException("Provided Metadata instance does not have metadataVersion in it and therefore is malformed and cannot be read.");
        }
        MetadataVersion jvmMetadataVersion = new MetadataVersion(annotationData.mv(), (annotationData.xi() & 8) != 0);
        this.throwIfNotCompatible$kotlin_metadata_jvm(jvmMetadataVersion, lenient);
    }

    public final void throwIfNotCompatible$kotlin_metadata_jvm(@NotNull MetadataVersion jvmMetadataVersion, boolean lenient) {
        boolean isCompatible;
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"jvmMetadataVersion");
        boolean isAtLeast110 = jvmMetadataVersion.isAtLeast(1, 1, 0);
        boolean bl = isCompatible = lenient ? isAtLeast110 : jvmMetadataVersion.isCompatibleWithCurrentCompilerVersion();
        if (!isCompatible) {
            String postfix = !isAtLeast110 ? "while minimum supported version is 1.1.0 (Kotlin 1.0)." : "while maximum supported version is " + (jvmMetadataVersion.isStrictSemantics() ? MetadataVersion.INSTANCE : MetadataVersion.INSTANCE_NEXT) + ". To support newer versions, update the kotlin-metadata-jvm library.";
            throw new IllegalArgumentException("Provided Metadata instance has version " + jvmMetadataVersion + ", " + postfix);
        }
    }
}

