/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.km.jvm;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.km.KmClass;
import kotlin.reflect.jvm.internal.impl.km.KmLambda;
import kotlin.reflect.jvm.internal.impl.km.KmPackage;
import kotlin.reflect.jvm.internal.impl.km.internal.ClassWriter;
import kotlin.reflect.jvm.internal.impl.km.internal.LambdaWriter;
import kotlin.reflect.jvm.internal.impl.km.internal.PackageWriter;
import kotlin.reflect.jvm.internal.impl.km.jvm.JvmMetadataUtil;
import kotlin.reflect.jvm.internal.impl.km.jvm.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.km.jvm.internal.JvmReadUtils;
import kotlin.reflect.jvm.internal.impl.km.jvm.internal.JvmWriteUtilsKt;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class KotlinClassMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isAllowedToWrite = true;
    public static final int CLASS_KIND = 1;
    public static final int FILE_FACADE_KIND = 2;
    public static final int SYNTHETIC_CLASS_KIND = 3;
    public static final int MULTI_FILE_CLASS_FACADE_KIND = 4;
    public static final int MULTI_FILE_CLASS_PART_KIND = 5;

    private KotlinClassMetadata() {
    }

    @NotNull
    public abstract Metadata write();

    @NotNull
    public abstract JvmMetadataVersion getVersion();

    public abstract void setVersion(@NotNull JvmMetadataVersion var1);

    public abstract int getFlags();

    public abstract void setFlags(int var1);

    public final boolean isAllowedToWrite$kotlin_metadata_jvm() {
        return this.isAllowedToWrite;
    }

    public final void setAllowedToWrite$kotlin_metadata_jvm(boolean bl) {
        this.isAllowedToWrite = bl;
    }

    @JvmStatic
    @NotNull
    public static final KotlinClassMetadata readStrict(@NotNull Metadata annotationData) {
        return Companion.readStrict(annotationData);
    }

    @JvmStatic
    @NotNull
    public static final KotlinClassMetadata readLenient(@NotNull Metadata annotationData) {
        return Companion.readLenient(annotationData);
    }

    public /* synthetic */ KotlinClassMetadata(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @SourceDebugExtension(value={"SMAP\nKotlinClassMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinClassMetadata.kt\nkotlin/metadata/jvm/KotlinClassMetadata$Class\n+ 2 JvmExceptionUtils.kt\nkotlin/metadata/jvm/internal/JvmExceptionUtilsKt\n*L\n1#1,477:1\n28#2,8:478\n*S KotlinDebug\n*F\n+ 1 KotlinClassMetadata.kt\nkotlin/metadata/jvm/KotlinClassMetadata$Class\n*L\n105#1:478,8\n*E\n"})
    public static final class Class
    extends KotlinClassMetadata {
        @NotNull
        private KmClass kmClass;
        @NotNull
        private JvmMetadataVersion version;
        private int flags;

        public Class(@NotNull KmClass kmClass, @NotNull JvmMetadataVersion version, int flags) {
            Intrinsics.checkNotNullParameter((Object)kmClass, (String)"kmClass");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            super(null);
            this.kmClass = kmClass;
            this.version = version;
            this.flags = flags;
        }

        @NotNull
        public final KmClass getKmClass() {
            return this.kmClass;
        }

        public final void setKmClass(@NotNull KmClass kmClass) {
            Intrinsics.checkNotNullParameter((Object)kmClass, (String)"<set-?>");
            this.kmClass = kmClass;
        }

        @Override
        @NotNull
        public JvmMetadataVersion getVersion() {
            return this.version;
        }

        @Override
        public void setVersion(@NotNull JvmMetadataVersion jvmMetadataVersion) {
            Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"<set-?>");
            this.version = jvmMetadataVersion;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public void setFlags(int n) {
            this.flags = n;
        }

        public Class(@NotNull Metadata annotationData, boolean lenient) {
            Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
            this(JvmReadUtils.INSTANCE.readKmClass$kotlin_metadata_jvm(annotationData), new JvmMetadataVersion(annotationData.mv()), annotationData.xi());
            this.setAllowedToWrite$kotlin_metadata_jvm(!lenient);
        }

        @Override
        @NotNull
        public Metadata write() {
            Metadata metadata;
            Companion.throwIfNotWriteable$kotlin_metadata_jvm(this.isAllowedToWrite$kotlin_metadata_jvm(), "class");
            Companion.checkMetadataVersionForWrite(this.getVersion());
            boolean $i$f$wrapWriteIntoIAE = false;
            try {
                boolean bl = false;
                ClassWriter writer = new ClassWriter(new JvmStringTable(null, 1, null), null, 2, null);
                writer.writeClass(this.kmClass);
                ProtoBuf.Class clazz = writer.getT().build();
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"build(...)");
                Pair<String[], String[]> pair = JvmWriteUtilsKt.writeProtoBufData(clazz, writer.getC());
                String[] d1 = (String[])pair.component1();
                String[] d2 = (String[])pair.component2();
                metadata = JvmMetadataUtil.Metadata$default(1, this.getVersion().toIntArray(), d1, d2, null, null, this.getFlags(), 48, null);
            }
            catch (Throwable e$iv) {
                Throwable throwable = e$iv;
                throw throwable instanceof IllegalArgumentException ? e$iv : (throwable instanceof VirtualMachineError || throwable instanceof ThreadDeath ? e$iv : (Throwable)new IllegalArgumentException("Kotlin metadata is not correct and can not be written", e$iv));
            }
            return metadata;
        }
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Metadata transform(@NotNull Metadata metadata, @NotNull Function1<? super KotlinClassMetadata, Unit> transformer) {
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
            KotlinClassMetadata kotlinClassMetadata = this.readStrict(metadata);
            transformer.invoke((Object)kotlinClassMetadata);
            return kotlinClassMetadata.write();
        }

        @JvmStatic
        @NotNull
        public final KotlinClassMetadata readStrict(@NotNull Metadata annotationData) {
            Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
            return JvmReadUtils.INSTANCE.readMetadataImpl$kotlin_metadata_jvm(annotationData, false);
        }

        @JvmStatic
        @NotNull
        public final KotlinClassMetadata readLenient(@NotNull Metadata annotationData) {
            Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
            return JvmReadUtils.INSTANCE.readMetadataImpl$kotlin_metadata_jvm(annotationData, true);
        }

        public final void throwIfNotWriteable$kotlin_metadata_jvm(boolean writeable, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (writeable) {
                return;
            }
            throw new IllegalArgumentException("This " + name + " cannot be written because it represents metadata read in lenient mode");
        }

        private final void checkMetadataVersionForWrite(JvmMetadataVersion version) {
            if (!(version.getMajor() >= 1 && (version.getMajor() > 1 || version.getMinor() >= 4))) {
                boolean $i$a$-require-KotlinClassMetadata$Companion$checkMetadataVersionForWrite$32 = false;
                String $i$a$-require-KotlinClassMetadata$Companion$checkMetadataVersionForWrite$32 = "This version of kotlinx-metadata-jvm doesn't support writing Kotlin metadata of version earlier than 1.4. Please change the version from " + version + " to at least [1, 4].";
                throw new IllegalArgumentException($i$a$-require-KotlinClassMetadata$Companion$checkMetadataVersionForWrite$32.toString());
            }
            if (!(version.compareTo(JvmMetadataVersion.HIGHEST_ALLOWED_TO_WRITE) <= 0)) {
                boolean bl = false;
                String string = "kotlinx-metadata-jvm cannot write metadata for future compiler versions. Requested to write version " + version + ", but highest known version is " + JvmMetadataVersion.HIGHEST_ALLOWED_TO_WRITE;
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @SourceDebugExtension(value={"SMAP\nKotlinClassMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinClassMetadata.kt\nkotlin/metadata/jvm/KotlinClassMetadata$FileFacade\n+ 2 JvmExceptionUtils.kt\nkotlin/metadata/jvm/internal/JvmExceptionUtilsKt\n*L\n1#1,477:1\n28#2,8:478\n*S KotlinDebug\n*F\n+ 1 KotlinClassMetadata.kt\nkotlin/metadata/jvm/KotlinClassMetadata$FileFacade\n*L\n150#1:478,8\n*E\n"})
    public static final class FileFacade
    extends KotlinClassMetadata {
        @NotNull
        private KmPackage kmPackage;
        @NotNull
        private JvmMetadataVersion version;
        private int flags;

        public FileFacade(@NotNull KmPackage kmPackage, @NotNull JvmMetadataVersion version, int flags) {
            Intrinsics.checkNotNullParameter((Object)kmPackage, (String)"kmPackage");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            super(null);
            this.kmPackage = kmPackage;
            this.version = version;
            this.flags = flags;
        }

        @NotNull
        public final KmPackage getKmPackage() {
            return this.kmPackage;
        }

        public final void setKmPackage(@NotNull KmPackage kmPackage) {
            Intrinsics.checkNotNullParameter((Object)kmPackage, (String)"<set-?>");
            this.kmPackage = kmPackage;
        }

        @Override
        @NotNull
        public JvmMetadataVersion getVersion() {
            return this.version;
        }

        @Override
        public void setVersion(@NotNull JvmMetadataVersion jvmMetadataVersion) {
            Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"<set-?>");
            this.version = jvmMetadataVersion;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public void setFlags(int n) {
            this.flags = n;
        }

        public FileFacade(@NotNull Metadata annotationData, boolean lenient) {
            Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
            this(JvmReadUtils.INSTANCE.readKmPackage$kotlin_metadata_jvm(annotationData), new JvmMetadataVersion(annotationData.mv()), annotationData.xi());
            this.setAllowedToWrite$kotlin_metadata_jvm(!lenient);
        }

        @Override
        @NotNull
        public Metadata write() {
            Metadata metadata;
            Companion.throwIfNotWriteable$kotlin_metadata_jvm(this.isAllowedToWrite$kotlin_metadata_jvm(), "file facade");
            Companion.checkMetadataVersionForWrite(this.getVersion());
            boolean $i$f$wrapWriteIntoIAE = false;
            try {
                boolean bl = false;
                PackageWriter writer = new PackageWriter(new JvmStringTable(null, 1, null), null, 2, null);
                writer.writePackage(this.kmPackage);
                ProtoBuf.Package package_ = writer.getT().build();
                Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"build(...)");
                Pair<String[], String[]> pair = JvmWriteUtilsKt.writeProtoBufData(package_, writer.getC());
                String[] d1 = (String[])pair.component1();
                String[] d2 = (String[])pair.component2();
                metadata = JvmMetadataUtil.Metadata$default(2, this.getVersion().toIntArray(), d1, d2, null, null, this.getFlags(), 48, null);
            }
            catch (Throwable e$iv) {
                Throwable throwable = e$iv;
                throw throwable instanceof IllegalArgumentException ? e$iv : (throwable instanceof VirtualMachineError || throwable instanceof ThreadDeath ? e$iv : (Throwable)new IllegalArgumentException("Kotlin metadata is not correct and can not be written", e$iv));
            }
            return metadata;
        }
    }

    @SourceDebugExtension(value={"SMAP\nKotlinClassMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinClassMetadata.kt\nkotlin/metadata/jvm/KotlinClassMetadata$MultiFileClassFacade\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,477:1\n37#2:478\n36#2,3:479\n*S KotlinDebug\n*F\n+ 1 KotlinClassMetadata.kt\nkotlin/metadata/jvm/KotlinClassMetadata$MultiFileClassFacade\n*L\n270#1:478\n270#1:479,3\n*E\n"})
    public static final class MultiFileClassFacade
    extends KotlinClassMetadata {
        @NotNull
        private List<String> partClassNames;
        @NotNull
        private JvmMetadataVersion version;
        private int flags;

        public MultiFileClassFacade(@NotNull List<String> partClassNames, @NotNull JvmMetadataVersion version, int flags) {
            Intrinsics.checkNotNullParameter(partClassNames, (String)"partClassNames");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            super(null);
            this.partClassNames = partClassNames;
            this.version = version;
            this.flags = flags;
        }

        @NotNull
        public final List<String> getPartClassNames() {
            return this.partClassNames;
        }

        public final void setPartClassNames(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.partClassNames = list;
        }

        @Override
        @NotNull
        public JvmMetadataVersion getVersion() {
            return this.version;
        }

        @Override
        public void setVersion(@NotNull JvmMetadataVersion jvmMetadataVersion) {
            Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"<set-?>");
            this.version = jvmMetadataVersion;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public void setFlags(int n) {
            this.flags = n;
        }

        public MultiFileClassFacade(@NotNull Metadata annotationData, boolean lenient) {
            Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
            this(ArraysKt.asList((Object[])annotationData.d1()), new JvmMetadataVersion(annotationData.mv()), annotationData.xi());
            this.setAllowedToWrite$kotlin_metadata_jvm(!lenient);
        }

        @Override
        @NotNull
        public Metadata write() {
            Companion.throwIfNotWriteable$kotlin_metadata_jvm(this.isAllowedToWrite$kotlin_metadata_jvm(), "multi-file class facade");
            Companion.checkMetadataVersionForWrite(this.getVersion());
            Collection $this$toTypedArray$iv = this.partClassNames;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return JvmMetadataUtil.Metadata$default(4, this.getVersion().toIntArray(), thisCollection$iv.toArray(new String[0]), null, null, null, this.getFlags(), 56, null);
        }
    }

    @SourceDebugExtension(value={"SMAP\nKotlinClassMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinClassMetadata.kt\nkotlin/metadata/jvm/KotlinClassMetadata$MultiFileClassPart\n+ 2 JvmExceptionUtils.kt\nkotlin/metadata/jvm/internal/JvmExceptionUtilsKt\n*L\n1#1,477:1\n28#2,8:478\n*S KotlinDebug\n*F\n+ 1 KotlinClassMetadata.kt\nkotlin/metadata/jvm/KotlinClassMetadata$MultiFileClassPart\n*L\n319#1:478,8\n*E\n"})
    public static final class MultiFileClassPart
    extends KotlinClassMetadata {
        @NotNull
        private KmPackage kmPackage;
        @NotNull
        private String facadeClassName;
        @NotNull
        private JvmMetadataVersion version;
        private int flags;

        public MultiFileClassPart(@NotNull KmPackage kmPackage, @NotNull String facadeClassName, @NotNull JvmMetadataVersion version, int flags) {
            Intrinsics.checkNotNullParameter((Object)kmPackage, (String)"kmPackage");
            Intrinsics.checkNotNullParameter((Object)facadeClassName, (String)"facadeClassName");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            super(null);
            this.kmPackage = kmPackage;
            this.facadeClassName = facadeClassName;
            this.version = version;
            this.flags = flags;
        }

        @NotNull
        public final KmPackage getKmPackage() {
            return this.kmPackage;
        }

        public final void setKmPackage(@NotNull KmPackage kmPackage) {
            Intrinsics.checkNotNullParameter((Object)kmPackage, (String)"<set-?>");
            this.kmPackage = kmPackage;
        }

        @NotNull
        public final String getFacadeClassName() {
            return this.facadeClassName;
        }

        public final void setFacadeClassName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.facadeClassName = string;
        }

        @Override
        @NotNull
        public JvmMetadataVersion getVersion() {
            return this.version;
        }

        @Override
        public void setVersion(@NotNull JvmMetadataVersion jvmMetadataVersion) {
            Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"<set-?>");
            this.version = jvmMetadataVersion;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public void setFlags(int n) {
            this.flags = n;
        }

        public MultiFileClassPart(@NotNull Metadata annotationData, boolean lenient) {
            Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
            this(JvmReadUtils.INSTANCE.readKmPackage$kotlin_metadata_jvm(annotationData), annotationData.xs(), new JvmMetadataVersion(annotationData.mv()), annotationData.xi());
            this.setAllowedToWrite$kotlin_metadata_jvm(!lenient);
        }

        @Override
        @NotNull
        public Metadata write() {
            Metadata metadata;
            Companion.throwIfNotWriteable$kotlin_metadata_jvm(this.isAllowedToWrite$kotlin_metadata_jvm(), "multi-file class part");
            Companion.checkMetadataVersionForWrite(this.getVersion());
            boolean $i$f$wrapWriteIntoIAE = false;
            try {
                boolean bl = false;
                PackageWriter writer = new PackageWriter(new JvmStringTable(null, 1, null), null, 2, null);
                writer.writePackage(this.kmPackage);
                ProtoBuf.Package package_ = writer.getT().build();
                Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"build(...)");
                Pair<String[], String[]> pair = JvmWriteUtilsKt.writeProtoBufData(package_, writer.getC());
                String[] d1 = (String[])pair.component1();
                String[] d2 = (String[])pair.component2();
                metadata = JvmMetadataUtil.Metadata$default(5, this.getVersion().toIntArray(), d1, d2, this.facadeClassName, null, this.getFlags(), 32, null);
            }
            catch (Throwable e$iv) {
                Throwable throwable = e$iv;
                throw throwable instanceof IllegalArgumentException ? e$iv : (throwable instanceof VirtualMachineError || throwable instanceof ThreadDeath ? e$iv : (Throwable)new IllegalArgumentException("Kotlin metadata is not correct and can not be written", e$iv));
            }
            return metadata;
        }
    }

    @SourceDebugExtension(value={"SMAP\nKotlinClassMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinClassMetadata.kt\nkotlin/metadata/jvm/KotlinClassMetadata$SyntheticClass\n+ 2 JvmExceptionUtils.kt\nkotlin/metadata/jvm/internal/JvmExceptionUtilsKt\n*L\n1#1,477:1\n28#2,8:478\n*S KotlinDebug\n*F\n+ 1 KotlinClassMetadata.kt\nkotlin/metadata/jvm/KotlinClassMetadata$SyntheticClass\n*L\n191#1:478,8\n*E\n"})
    public static final class SyntheticClass
    extends KotlinClassMetadata {
        @Nullable
        private KmLambda kmLambda;
        @NotNull
        private JvmMetadataVersion version;
        private int flags;

        public SyntheticClass(@Nullable KmLambda kmLambda, @NotNull JvmMetadataVersion version, int flags) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            super(null);
            this.kmLambda = kmLambda;
            this.version = version;
            this.flags = flags;
        }

        @Nullable
        public final KmLambda getKmLambda() {
            return this.kmLambda;
        }

        public final void setKmLambda(@Nullable KmLambda kmLambda) {
            this.kmLambda = kmLambda;
        }

        @Override
        @NotNull
        public JvmMetadataVersion getVersion() {
            return this.version;
        }

        @Override
        public void setVersion(@NotNull JvmMetadataVersion jvmMetadataVersion) {
            Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"<set-?>");
            this.version = jvmMetadataVersion;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public void setFlags(int n) {
            this.flags = n;
        }

        public SyntheticClass(@NotNull Metadata annotationData, boolean lenient) {
            Intrinsics.checkNotNullParameter((Object)annotationData, (String)"annotationData");
            this(JvmReadUtils.INSTANCE.readKmLambda$kotlin_metadata_jvm(annotationData), new JvmMetadataVersion(annotationData.mv()), annotationData.xi());
            this.setAllowedToWrite$kotlin_metadata_jvm(!lenient);
        }

        @Override
        @NotNull
        public Metadata write() {
            Metadata metadata;
            Companion.throwIfNotWriteable$kotlin_metadata_jvm(this.isAllowedToWrite$kotlin_metadata_jvm(), this.isLambda() ? "lambda" : "synthetic class");
            Companion.checkMetadataVersionForWrite(this.getVersion());
            if (this.isLambda()) {
                Metadata metadata2;
                boolean $i$f$wrapWriteIntoIAE = false;
                try {
                    ProtoBuf.Function proto;
                    boolean bl = false;
                    LambdaWriter writer = new LambdaWriter(new JvmStringTable(null, 1, null));
                    KmLambda kmLambda = this.kmLambda;
                    Intrinsics.checkNotNull((Object)kmLambda);
                    writer.writeLambda(kmLambda);
                    ProtoBuf.Function.Builder builder = writer.getT();
                    ProtoBuf.Function function = proto = builder != null ? builder.build() : null;
                    Pair pair = function != null ? JvmWriteUtilsKt.writeProtoBufData(function, writer.getC()) : new Pair((Object)new String[0], (Object)new String[0]);
                    String[] d1 = (String[])pair.component1();
                    String[] d2 = (String[])pair.component2();
                    metadata2 = JvmMetadataUtil.Metadata$default(3, this.getVersion().toIntArray(), d1, d2, null, null, this.getFlags(), 48, null);
                }
                catch (Throwable e$iv) {
                    Throwable throwable = e$iv;
                    throw throwable instanceof IllegalArgumentException ? e$iv : (throwable instanceof VirtualMachineError || throwable instanceof ThreadDeath ? e$iv : (Throwable)new IllegalArgumentException("Kotlin metadata is not correct and can not be written", e$iv));
                }
                metadata = metadata2;
            } else {
                metadata = JvmMetadataUtil.Metadata$default(3, this.getVersion().toIntArray(), new String[0], new String[0], null, null, this.getFlags(), 48, null);
            }
            return metadata;
        }

        public final boolean isLambda() {
            return this.kmLambda != null;
        }
    }

    public static final class Unknown
    extends KotlinClassMetadata {
        @NotNull
        private final Metadata original;
        private final boolean lenient;
        @NotNull
        private JvmMetadataVersion version;
        private int flags;

        public Unknown(@NotNull Metadata original, boolean lenient) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            super(null);
            this.original = original;
            this.lenient = lenient;
            this.version = new JvmMetadataVersion(this.original.mv());
            this.flags = this.original.xi();
        }

        @Override
        @NotNull
        public JvmMetadataVersion getVersion() {
            return this.version;
        }

        @Override
        public void setVersion(@NotNull JvmMetadataVersion jvmMetadataVersion) {
            Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"<set-?>");
            this.version = jvmMetadataVersion;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public void setFlags(int n) {
            this.flags = n;
        }

        @Override
        @NotNull
        public Metadata write() {
            Companion.throwIfNotWriteable$kotlin_metadata_jvm(!this.lenient, "unknown kind");
            Companion.checkMetadataVersionForWrite(this.getVersion());
            return JvmMetadataUtil.Metadata(this.original.k(), this.getVersion().toIntArray(), this.original.d1(), this.original.d2(), this.original.xs(), this.original.pn(), this.getFlags());
        }
    }
}

