/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.km.jvm;

import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.MetadataVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nJvmMetadataVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmMetadataVersion.kt\nkotlin/metadata/jvm/JvmMetadataVersion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class JvmMetadataVersion
implements Comparable<JvmMetadataVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;
    @JvmField
    @NotNull
    public static final JvmMetadataVersion LATEST_STABLE_SUPPORTED = new JvmMetadataVersion(MetadataVersion.INSTANCE.toArray());
    @JvmField
    @NotNull
    public static final JvmMetadataVersion HIGHEST_ALLOWED_TO_WRITE = new JvmMetadataVersion(MetadataVersion.INSTANCE_NEXT.toArray());

    public JvmMetadataVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        if (!(this.major >= 0)) {
            boolean $i$a$-require-JvmMetadataVersion$42 = false;
            String $i$a$-require-JvmMetadataVersion$42 = "Major version should be not less than 0";
            throw new IllegalArgumentException($i$a$-require-JvmMetadataVersion$42.toString());
        }
        if (!(this.minor >= 0)) {
            boolean $i$a$-require-JvmMetadataVersion$52 = false;
            String $i$a$-require-JvmMetadataVersion$52 = "Minor version should be not less than 0";
            throw new IllegalArgumentException($i$a$-require-JvmMetadataVersion$52.toString());
        }
        if (!(this.patch >= 0)) {
            boolean bl = false;
            String string = "Patch version should be not less than 0";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    public JvmMetadataVersion(int major, int minor) {
        this(major, minor, 0);
    }

    public JvmMetadataVersion(@NotNull int[] intArray) {
        Intrinsics.checkNotNullParameter((Object)intArray, (String)"intArray");
        this(intArray[0], intArray[1], intArray[2]);
    }

    @JvmName(name="toIntArray")
    @NotNull
    public final int[] toIntArray() {
        int[] nArray = new int[]{this.major, this.minor, this.patch};
        return nArray;
    }

    @Override
    public int compareTo(@NotNull JvmMetadataVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int majors = Intrinsics.compare((int)this.major, (int)other.major);
        if (majors != 0) {
            return majors;
        }
        int minors = Intrinsics.compare((int)this.minor, (int)other.minor);
        return minors != 0 ? minors : Intrinsics.compare((int)this.patch, (int)other.patch);
    }

    @NotNull
    public String toString() {
        return "" + this.major + '.' + this.minor + '.' + this.patch;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type kotlin.metadata.jvm.JvmMetadataVersion");
        JvmMetadataVersion cfr_ignored_0 = (JvmMetadataVersion)other;
        if (this.major != ((JvmMetadataVersion)other).major) {
            return false;
        }
        if (this.minor != ((JvmMetadataVersion)other).minor) {
            return false;
        }
        return this.patch == ((JvmMetadataVersion)other).patch;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

