/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.km.internal;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.km.internal.WriteContextExtension;
import kotlin.reflect.jvm.internal.impl.km.internal.WriteUtilsKt;
import kotlin.reflect.jvm.internal.impl.km.internal.extensions.MetadataExtensions;
import kotlin.reflect.jvm.internal.impl.metadata.serialization.MutableVersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.metadata.serialization.StringTable;
import org.jetbrains.annotations.NotNull;

public class WriteContext {
    @NotNull
    private final StringTable strings;
    @NotNull
    private final List<WriteContextExtension> contextExtensions;
    @NotNull
    private final MutableVersionRequirementTable versionRequirements;
    @NotNull
    private final List<MetadataExtensions> extensions;

    public WriteContext(@NotNull StringTable strings, @NotNull List<? extends WriteContextExtension> contextExtensions) {
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        Intrinsics.checkNotNullParameter(contextExtensions, (String)"contextExtensions");
        this.strings = strings;
        this.contextExtensions = contextExtensions;
        this.versionRequirements = new MutableVersionRequirementTable();
        this.extensions = MetadataExtensions.Companion.getINSTANCES$kotlin_metadata();
    }

    public /* synthetic */ WriteContext(StringTable stringTable, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(stringTable, list);
    }

    @NotNull
    public final StringTable getStrings() {
        return this.strings;
    }

    @NotNull
    public final List<WriteContextExtension> getContextExtensions() {
        return this.contextExtensions;
    }

    @NotNull
    public final MutableVersionRequirementTable getVersionRequirements$kotlin_metadata() {
        return this.versionRequirements;
    }

    @NotNull
    public final List<MetadataExtensions> getExtensions$kotlin_metadata() {
        return this.extensions;
    }

    public final int get(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.strings.getStringIndex(string);
    }

    public final int getClassName$kotlin_metadata(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return WriteUtilsKt.getClassNameIndex(this.strings, name);
    }
}

