/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.km;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KmVersion {
    private final int major;
    private final int minor;
    private final int patch;

    public KmVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @NotNull
    public String toString() {
        return "" + this.major + '.' + this.minor + '.' + this.patch;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @NotNull
    public final KmVersion copy(int major, int minor, int patch) {
        return new KmVersion(major, minor, patch);
    }

    public static /* synthetic */ KmVersion copy$default(KmVersion kmVersion, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = kmVersion.major;
        }
        if ((n4 & 2) != 0) {
            n2 = kmVersion.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = kmVersion.patch;
        }
        return kmVersion.copy(n, n2, n3);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.major);
        result = result * 31 + Integer.hashCode(this.minor);
        result = result * 31 + Integer.hashCode(this.patch);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KmVersion)) {
            return false;
        }
        KmVersion kmVersion = (KmVersion)other;
        if (this.major != kmVersion.major) {
            return false;
        }
        if (this.minor != kmVersion.minor) {
            return false;
        }
        return this.patch == kmVersion.patch;
    }
}

