/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.incremental.components;

import java.io.Serializable;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.incremental.components.Position;
import kotlin.reflect.jvm.internal.impl.incremental.components.ScopeKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LookupInfo
implements Serializable {
    @NotNull
    private final String filePath;
    @NotNull
    private final Position position;
    @NotNull
    private final String scopeFqName;
    @NotNull
    private final ScopeKind scopeKind;
    @NotNull
    private final String name;

    public LookupInfo(@NotNull String filePath, @NotNull Position position, @NotNull String scopeFqName, @NotNull ScopeKind scopeKind, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)scopeFqName, (String)"scopeFqName");
        Intrinsics.checkNotNullParameter((Object)((Object)scopeKind), (String)"scopeKind");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.filePath = filePath;
        this.position = position;
        this.scopeFqName = scopeFqName;
        this.scopeKind = scopeKind;
        this.name = name;
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    @NotNull
    public final Position getPosition() {
        return this.position;
    }

    @NotNull
    public final String getScopeFqName() {
        return this.scopeFqName;
    }

    @NotNull
    public final ScopeKind getScopeKind() {
        return this.scopeKind;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String component1() {
        return this.filePath;
    }

    @NotNull
    public final Position component2() {
        return this.position;
    }

    @NotNull
    public final String component3() {
        return this.scopeFqName;
    }

    @NotNull
    public final ScopeKind component4() {
        return this.scopeKind;
    }

    @NotNull
    public final String component5() {
        return this.name;
    }

    @NotNull
    public final LookupInfo copy(@NotNull String filePath, @NotNull Position position, @NotNull String scopeFqName, @NotNull ScopeKind scopeKind, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)scopeFqName, (String)"scopeFqName");
        Intrinsics.checkNotNullParameter((Object)((Object)scopeKind), (String)"scopeKind");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new LookupInfo(filePath, position, scopeFqName, scopeKind, name);
    }

    public static /* synthetic */ LookupInfo copy$default(LookupInfo lookupInfo, String string, Position position, String string2, ScopeKind scopeKind, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = lookupInfo.filePath;
        }
        if ((n & 2) != 0) {
            position = lookupInfo.position;
        }
        if ((n & 4) != 0) {
            string2 = lookupInfo.scopeFqName;
        }
        if ((n & 8) != 0) {
            scopeKind = lookupInfo.scopeKind;
        }
        if ((n & 0x10) != 0) {
            string3 = lookupInfo.name;
        }
        return lookupInfo.copy(string, position, string2, scopeKind, string3);
    }

    @NotNull
    public String toString() {
        return "LookupInfo(filePath=" + this.filePath + ", position=" + this.position + ", scopeFqName=" + this.scopeFqName + ", scopeKind=" + (Object)((Object)this.scopeKind) + ", name=" + this.name + ')';
    }

    public int hashCode() {
        int result = this.filePath.hashCode();
        result = result * 31 + this.position.hashCode();
        result = result * 31 + this.scopeFqName.hashCode();
        result = result * 31 + this.scopeKind.hashCode();
        result = result * 31 + this.name.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LookupInfo)) {
            return false;
        }
        LookupInfo lookupInfo = (LookupInfo)other;
        if (!Intrinsics.areEqual((Object)this.filePath, (Object)lookupInfo.filePath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.position, (Object)lookupInfo.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scopeFqName, (Object)lookupInfo.scopeFqName)) {
            return false;
        }
        if (this.scopeKind != lookupInfo.scopeKind) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)lookupInfo.name);
    }
}

