/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.Java16SealedRecordLoader;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClassifierType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaConstructor;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaField;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaMethod;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaModifierListOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaRecordComponent;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaRecordComponent;
import kotlin.reflect.jvm.internal.impl.load.java.structure.LightClassOriginKind;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nReflectJavaClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectJavaClass.kt\norg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaClass\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,209:1\n183#2,2:210\n1#3:212\n1563#4:213\n1634#4,3:214\n11228#5:217\n11563#5,3:218\n11228#5:221\n11563#5,3:222\n11228#5:225\n11563#5,3:226\n*S KotlinDebug\n*F\n+ 1 ReflectJavaClass.kt\norg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaClass\n*L\n51#1:210,2\n64#1:213\n64#1:214,3\n118#1:217\n118#1:218,3\n131#1:221\n131#1:222,3\n138#1:225\n138#1:226,3\n*E\n"})
public final class ReflectJavaClass
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaClass {
    @NotNull
    private final Class<?> klass;

    public ReflectJavaClass(@NotNull Class<?> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        this.klass = klass;
    }

    @Override
    @NotNull
    public Class<?> getElement() {
        return this.klass;
    }

    @Override
    public int getModifiers() {
        return this.klass.getModifiers();
    }

    @Override
    public boolean isFromSource() {
        return false;
    }

    @NotNull
    public List<Name> getInnerClassNames() {
        Class<?>[] classArray = this.klass.getDeclaredClasses();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])classArray), ReflectJavaClass::_get_innerClassNames_$lambda$0), ReflectJavaClass::_get_innerClassNames_$lambda$2));
    }

    @Override
    @Nullable
    public ReflectJavaClass findInnerClass(@NotNull Name name) {
        ReflectJavaClass reflectJavaClass;
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Class<?>[] classArray = this.klass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
            Sequence $this$firstOrNull$iv = ArraysKt.asSequence((Object[])classArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Class it = (Class)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSimpleName(), (Object)name.asString())) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Class clazz = v1;
        if (clazz != null) {
            Class p0 = clazz;
            boolean bl = false;
            reflectJavaClass = new ReflectJavaClass(p0);
        } else {
            reflectJavaClass = null;
        }
        return reflectJavaClass;
    }

    @Override
    @NotNull
    public FqName getFqName() {
        return ReflectClassUtilKt.getClassId(this.klass).asSingleFqName();
    }

    @Override
    @Nullable
    public ReflectJavaClass getOuterClass() {
        ReflectJavaClass reflectJavaClass;
        Class<?> clazz = this.klass.getDeclaringClass();
        if (clazz != null) {
            Class<?> p0 = clazz;
            boolean bl = false;
            reflectJavaClass = new ReflectJavaClass(p0);
        } else {
            reflectJavaClass = null;
        }
        return reflectJavaClass;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<JavaClassifierType> getSupertypes() {
        void $this$mapTo$iv$iv;
        if (Intrinsics.areEqual(this.klass, Object.class)) {
            return CollectionsKt.emptyList();
        }
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        Type type = this.klass.getGenericSuperclass();
        if (type == null) {
            type = (Type)((Object)Object.class);
        }
        spreadBuilder.add((Object)type);
        spreadBuilder.addSpread((Object)this.klass.getGenericInterfaces());
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()]));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Type type2 = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ReflectJavaClassifierType((Type)p0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<ReflectJavaMethod> getMethods() {
        Method[] methodArray = this.klass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])methodArray), arg_0 -> ReflectJavaClass._get_methods_$lambda$7(this, arg_0)), (Function1)methods.2.INSTANCE));
    }

    private final boolean isEnumValuesOrValueOf(Method method) {
        boolean bl;
        String string = method.getName();
        if (Intrinsics.areEqual((Object)string, (Object)"values")) {
            Class<?>[] classArray = method.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
            bl = ((Object[])classArray).length == 0;
        } else if (Intrinsics.areEqual((Object)string, (Object)"valueOf")) {
            Object[] objectArray = new Class[]{String.class};
            bl = Arrays.equals(method.getParameterTypes(), objectArray);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public List<ReflectJavaField> getFields() {
        Field[] fieldArray = this.klass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])fieldArray), (Function1)fields.1.INSTANCE), (Function1)fields.2.INSTANCE));
    }

    @NotNull
    public List<ReflectJavaConstructor> getConstructors() {
        Constructor<?>[] constructorArray = this.klass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getDeclaredConstructors(...)");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])constructorArray), (Function1)constructors.1.INSTANCE), (Function1)constructors.2.INSTANCE));
    }

    @Override
    public boolean hasDefaultConstructor() {
        return false;
    }

    @Override
    @Nullable
    public LightClassOriginKind getLightClassOriginKind() {
        return null;
    }

    @Override
    @NotNull
    public Name getName() {
        Name name;
        if (this.klass.isAnonymousClass()) {
            String string = this.klass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Name name2 = Name.identifier(StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null));
            Intrinsics.checkNotNull((Object)name2);
            name = name2;
        } else {
            Name name3 = Name.identifier(this.klass.getSimpleName());
            Intrinsics.checkNotNull((Object)name3);
            name = name3;
        }
        return name;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ReflectJavaTypeParameter> getTypeParameters() {
        void $this$mapTo$iv$iv;
        TypeVariable<Class<?>>[] typeVariableArray = this.klass.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"getTypeParameters(...)");
        Object[] $this$map$iv = typeVariableArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeVariable typeVariable = (TypeVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ReflectJavaTypeParameter((TypeVariable<?>)p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean isInterface() {
        return this.klass.isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return this.klass.isAnnotation();
    }

    @Override
    public boolean isEnum() {
        return this.klass.isEnum();
    }

    @Override
    public boolean isRecord() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsRecord(this.klass);
        return bl != null ? bl : false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<JavaRecordComponent> getRecordComponents() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = Java16SealedRecordLoader.INSTANCE.loadGetRecordComponents(this.klass);
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Object[] $this$map$iv = objectArray;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p0;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ReflectJavaRecordComponent(p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean isSealed() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsSealed(this.klass);
        return bl != null ? bl : false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Sequence<JavaClassifierType> getPermittedTypes() {
        Sequence sequence;
        Class<?>[] classArray = Java16SealedRecordLoader.INSTANCE.loadGetPermittedSubclasses(this.klass);
        if (classArray != null) {
            void $this$mapTo$iv$iv;
            Class<?>[] $this$map$iv = classArray;
            boolean $i$f$map = false;
            Class<?>[] classArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Type type = (Type)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ReflectJavaClassifierType((Type)p0));
            }
            Sequence sequence2 = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
            if (sequence2 != null) {
                sequence = sequence2;
                return sequence;
            }
        }
        sequence = SequencesKt.emptySequence();
        return sequence;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ReflectJavaClass && Intrinsics.areEqual(this.klass, ((ReflectJavaClass)other).klass);
    }

    public int hashCode() {
        return this.klass.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + ": " + this.klass;
    }

    private static final boolean _get_innerClassNames_$lambda$0(Class it) {
        String string = it.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return ((CharSequence)string).length() == 0;
    }

    private static final Name _get_innerClassNames_$lambda$2(Class it) {
        Name name;
        String string;
        String p0 = string = it.getSimpleName();
        boolean bl = false;
        String string2 = Name.isValidIdentifier(p0) ? string : null;
        if (string2 != null) {
            p0 = string2;
            boolean bl2 = false;
            name = Name.identifier(p0);
        } else {
            name = null;
        }
        return name;
    }

    private static final boolean _get_methods_$lambda$7(ReflectJavaClass this$0, Method method) {
        boolean bl;
        if (method.isSynthetic()) {
            bl = false;
        } else if (this$0.isEnum()) {
            Intrinsics.checkNotNull((Object)method);
            bl = !this$0.isEnumValuesOrValueOf(method);
        } else {
            bl = true;
        }
        return bl;
    }
}

