/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.EffectiveVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Visibility {
    @NotNull
    private final String name;
    private final boolean isPublicAPI;

    protected Visibility(@NotNull String name, boolean isPublicAPI) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.isPublicAPI = isPublicAPI;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean isPublicAPI() {
        return this.isPublicAPI;
    }

    @NotNull
    public String getInternalDisplayName() {
        return this.name;
    }

    @NotNull
    public String getExternalDisplayName() {
        return this.getInternalDisplayName();
    }

    public abstract boolean mustCheckInImports();

    @Nullable
    public Integer compareTo(@NotNull Visibility visibility2) {
        Intrinsics.checkNotNullParameter((Object)visibility2, (String)"visibility");
        return Visibilities.INSTANCE.compareLocal$compiler_common(this, visibility2);
    }

    @NotNull
    public final String toString() {
        return this.getInternalDisplayName();
    }

    @NotNull
    public Visibility normalize() {
        return this;
    }

    @Nullable
    public EffectiveVisibility customEffectiveVisibility() {
        return null;
    }

    public boolean visibleFromPackage(@NotNull FqName fromPackage, @NotNull FqName myPackage) {
        Intrinsics.checkNotNullParameter((Object)fromPackage, (String)"fromPackage");
        Intrinsics.checkNotNullParameter((Object)myPackage, (String)"myPackage");
        return true;
    }
}

