/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import org.jetbrains.annotations.NotNull;

public final class ModalityUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOverridable(@NotNull CallableMemberDescriptor $this$isOverridable) {
        Intrinsics.checkNotNullParameter((Object)$this$isOverridable, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$isOverridable.getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) return false;
        if ($this$isOverridable.getModality() == Modality.FINAL) return false;
        DeclarationDescriptor declarationDescriptor = $this$isOverridable.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) return true;
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) return true;
        if (!ModalityUtilsKt.isFinalClass(classDescriptor)) return true;
        return false;
    }

    public static final boolean isOverridableOrOverrides(@NotNull CallableMemberDescriptor $this$isOverridableOrOverrides) {
        Intrinsics.checkNotNullParameter((Object)$this$isOverridableOrOverrides, (String)"<this>");
        return ModalityUtilsKt.isOverridable($this$isOverridableOrOverrides) || DescriptorUtils.isOverride($this$isOverridableOrOverrides);
    }

    public static final boolean isFinalClass(@NotNull ClassDescriptor $this$isFinalClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isFinalClass, (String)"<this>");
        return $this$isFinalClass.getModality() == Modality.FINAL && $this$isFinalClass.getKind() != ClassKind.ENUM_CLASS;
    }

    public static final boolean isFinalOrEnum(@NotNull ClassDescriptor $this$isFinalOrEnum) {
        Intrinsics.checkNotNullParameter((Object)$this$isFinalOrEnum, (String)"<this>");
        return $this$isFinalOrEnum.getModality() == Modality.FINAL;
    }
}

