/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.EffectiveVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.EffectiveVisibilityUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.RelationToType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorWithRelation {
    @NotNull
    private final ClassifierDescriptor descriptor;
    @NotNull
    private final RelationToType relation;

    public DescriptorWithRelation(@NotNull ClassifierDescriptor descriptor2, @NotNull RelationToType relation) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
        this.descriptor = descriptor2;
        this.relation = relation;
    }

    @NotNull
    public final ClassifierDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final EffectiveVisibility effectiveVisibility() {
        ClassifierDescriptor classifierDescriptor = this.descriptor;
        Object object = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (object == null || (object = object.getVisibility()) == null || (object = EffectiveVisibilityUtilsKt.effectiveVisibility((DescriptorVisibility)object, this.descriptor, false)) == null) {
            object = EffectiveVisibility.Public.INSTANCE;
        }
        return object;
    }

    @NotNull
    public String toString() {
        return "" + (Object)((Object)this.relation) + ' ' + this.descriptor.getName();
    }

    @NotNull
    public final ClassifierDescriptor component1() {
        return this.descriptor;
    }

    private final RelationToType component2() {
        return this.relation;
    }

    @NotNull
    public final DescriptorWithRelation copy(@NotNull ClassifierDescriptor descriptor2, @NotNull RelationToType relation) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
        return new DescriptorWithRelation(descriptor2, relation);
    }

    public static /* synthetic */ DescriptorWithRelation copy$default(DescriptorWithRelation descriptorWithRelation, ClassifierDescriptor classifierDescriptor, RelationToType relationToType, int n, Object object) {
        if ((n & 1) != 0) {
            classifierDescriptor = descriptorWithRelation.descriptor;
        }
        if ((n & 2) != 0) {
            relationToType = descriptorWithRelation.relation;
        }
        return descriptorWithRelation.copy(classifierDescriptor, relationToType);
    }

    public int hashCode() {
        int result = this.descriptor.hashCode();
        result = result * 31 + this.relation.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DescriptorWithRelation)) {
            return false;
        }
        DescriptorWithRelation descriptorWithRelation = (DescriptorWithRelation)other;
        if (!Intrinsics.areEqual((Object)this.descriptor, (Object)descriptorWithRelation.descriptor)) {
            return false;
        }
        return this.relation == descriptorWithRelation.relation;
    }
}

