/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.OperatorNameConventions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\ndescriptorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 descriptorUtil.kt\norg/jetbrains/kotlin/descriptors/DescriptorUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 coreLib.kt\norg/jetbrains/kotlin/utils/CoreLibKt\n*L\n1#1,113:1\n1#2:114\n19#3:115\n*S KotlinDebug\n*F\n+ 1 descriptorUtil.kt\norg/jetbrains/kotlin/descriptors/DescriptorUtilKt\n*L\n38#1:115\n*E\n"})
public final class DescriptorUtilKt {
    @Nullable
    public static final ClassDescriptor resolveClassByFqName(@NotNull ModuleDescriptor $this$resolveClassByFqName, @NotNull FqName fqName, @NotNull LookupLocation lookupLocation) {
        MemberScope memberScope;
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$resolveClassByFqName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"lookupLocation");
        if (fqName.isRoot()) {
            return null;
        }
        ClassifierDescriptor classifierDescriptor = $this$resolveClassByFqName.getPackage(fqName.parent()).getMemberScope().getContributedClassifier(fqName.shortName(), lookupLocation);
        ClassDescriptor classDescriptor2 = classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor != null) {
            ClassDescriptor it = classDescriptor;
            boolean bl = false;
            return it;
        }
        classifierDescriptor = DescriptorUtilKt.resolveClassByFqName($this$resolveClassByFqName, fqName.parent(), lookupLocation);
        classDescriptor = classifierDescriptor != null && (memberScope = classifierDescriptor.getUnsubstitutedInnerClassesScope()) != null ? memberScope.getContributedClassifier(fqName.shortName(), lookupLocation) : null;
        return classDescriptor instanceof ClassDescriptor ? classDescriptor : null;
    }

    @Nullable
    public static final ClassDescriptor findContinuationClassDescriptorOrNull(@NotNull ModuleDescriptor $this$findContinuationClassDescriptorOrNull, @NotNull LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$findContinuationClassDescriptorOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"lookupLocation");
        return DescriptorUtilKt.resolveClassByFqName($this$findContinuationClassDescriptorOrNull, StandardNames.CONTINUATION_INTERFACE_FQ_NAME, lookupLocation);
    }

    @NotNull
    public static final ClassDescriptor findContinuationClassDescriptor(@NotNull ModuleDescriptor $this$findContinuationClassDescriptor, @NotNull LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$findContinuationClassDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"lookupLocation");
        ClassDescriptor $this$sure$iv = DescriptorUtilKt.findContinuationClassDescriptorOrNull($this$findContinuationClassDescriptor, lookupLocation);
        boolean $i$f$sure = false;
        ClassDescriptor classDescriptor = $this$sure$iv;
        if (classDescriptor == null) {
            boolean bl = false;
            String string = "Continuation interface is not found";
            throw new AssertionError((Object)string);
        }
        return classDescriptor;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final SimpleType getContinuationOfTypeOrAny(@NotNull ModuleDescriptor $this$getContinuationOfTypeOrAny, @NotNull KotlinType kotlinType) {
        SimpleType simpleType;
        SimpleType simpleType2;
        Intrinsics.checkNotNullParameter((Object)$this$getContinuationOfTypeOrAny, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        ClassDescriptor classDescriptor = DescriptorUtilKt.findContinuationClassDescriptorOrNull(DescriptorUtilsKt.getModule($this$getContinuationOfTypeOrAny), NoLookupLocation.FROM_DESERIALIZATION);
        if (classDescriptor != null && (simpleType2 = classDescriptor.getDefaultType()) != null) {
            SimpleType it = simpleType2;
            boolean bl = false;
            SimpleType simpleType3 = KotlinTypeFactory.simpleType$default(it, null, null, CollectionsKt.listOf((Object)TypeUtilsKt.asTypeProjection(kotlinType)), false, 22, null);
            if (simpleType3 != null) {
                simpleType = simpleType3;
                return simpleType;
            }
        }
        SimpleType simpleType4 = DescriptorUtilsKt.getModule($this$getContinuationOfTypeOrAny).getBuiltIns().getNullableAnyType();
        simpleType = simpleType4;
        Intrinsics.checkNotNullExpressionValue((Object)simpleType4, (String)"getNullableAnyType(...)");
        return simpleType;
    }

    public static final boolean isTopLevelInPackage(@NotNull DeclarationDescriptor $this$isTopLevelInPackage, @NotNull String name, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)$this$isTopLevelInPackage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (!Intrinsics.areEqual((Object)name, (Object)$this$isTopLevelInPackage.getName().asString())) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = $this$isTopLevelInPackage.getContainingDeclaration();
        PackageFragmentDescriptor packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
        if (packageFragmentDescriptor == null) {
            return false;
        }
        PackageFragmentDescriptor containingDeclaration = packageFragmentDescriptor;
        String packageFqName = containingDeclaration.getFqName().asString();
        return Intrinsics.areEqual((Object)packageName, (Object)packageFqName);
    }

    public static final boolean isTopLevelInPackage(@NotNull DeclarationDescriptor $this$isTopLevelInPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$isTopLevelInPackage, (String)"<this>");
        return $this$isTopLevelInPackage.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    @Nullable
    public static final ClassifierDescriptor getTopLevelContainingClassifier(@NotNull DeclarationDescriptor $this$getTopLevelContainingClassifier) {
        Intrinsics.checkNotNullParameter((Object)$this$getTopLevelContainingClassifier, (String)"<this>");
        DeclarationDescriptor containingDeclaration = $this$getTopLevelContainingClassifier.getContainingDeclaration();
        if (containingDeclaration == null || $this$getTopLevelContainingClassifier instanceof PackageFragmentDescriptor) {
            return null;
        }
        return !DescriptorUtilKt.isTopLevelInPackage(containingDeclaration) ? DescriptorUtilKt.getTopLevelContainingClassifier(containingDeclaration) : (containingDeclaration instanceof ClassifierDescriptor ? (ClassifierDescriptor)containingDeclaration : null);
    }

    public static final boolean isSupportedForCallableReference(@NotNull CallableDescriptor $this$isSupportedForCallableReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isSupportedForCallableReference, (String)"<this>");
        return $this$isSupportedForCallableReference instanceof PropertyDescriptor || $this$isSupportedForCallableReference instanceof FunctionDescriptor;
    }

    public static final boolean isSealed(@NotNull DeclarationDescriptor $this$isSealed) {
        Intrinsics.checkNotNullParameter((Object)$this$isSealed, (String)"<this>");
        return DescriptorUtils.isSealedClass($this$isSealed);
    }

    @Nullable
    public static final FqName containingPackage(@NotNull DeclarationDescriptor $this$containingPackage) {
        DeclarationDescriptor container;
        Intrinsics.checkNotNullParameter((Object)$this$containingPackage, (String)"<this>");
        for (container = $this$containingPackage.getContainingDeclaration(); container != null && !(container instanceof PackageFragmentDescriptor); container = container.getContainingDeclaration()) {
        }
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)container;
        return packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTypedEqualsInValueClass(@NotNull FunctionDescriptor $this$isTypedEqualsInValueClass) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$isTypedEqualsInValueClass, (String)"<this>");
        DeclarationDescriptor declarationDescriptor = $this$isTypedEqualsInValueClass.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) return false;
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
        Annotated annotated = classDescriptor2;
        if (classDescriptor2 == null) return false;
        ClassDescriptor it = classDescriptor = annotated;
        boolean bl = false;
        if (!InlineClassesUtilsKt.isValueClass(it)) return false;
        ClassDescriptor classDescriptor3 = classDescriptor;
        annotated = classDescriptor3;
        if (classDescriptor3 == null) return false;
        SimpleType simpleType = annotated.getDefaultType();
        annotated = simpleType;
        if (simpleType == null) return false;
        if ((annotated = TypeUtilsKt.replaceArgumentsWithStarProjections((KotlinType)annotated)) == null) {
            return false;
        }
        Annotated annotated2 = annotated;
        KotlinType kotlinType = $this$isTypedEqualsInValueClass.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType returnType = kotlinType;
        if (!Intrinsics.areEqual((Object)$this$isTypedEqualsInValueClass.getName(), (Object)OperatorNameConventions.EQUALS)) return false;
        if (!TypeUtilsKt.isBoolean(returnType)) {
            if (!TypeUtilsKt.isNothing(returnType)) return false;
        }
        if ($this$isTypedEqualsInValueClass.getValueParameters().size() != 1) return false;
        KotlinType kotlinType2 = $this$isTypedEqualsInValueClass.getValueParameters().get(0).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
        if (!Intrinsics.areEqual((Object)TypeUtilsKt.replaceArgumentsWithStarProjections(kotlinType2), (Object)annotated2)) return false;
        if (!$this$isTypedEqualsInValueClass.getContextReceiverParameters().isEmpty()) return false;
        if ($this$isTypedEqualsInValueClass.getExtensionReceiverParameter() != null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean overridesEqualsFromAny(@NotNull FunctionDescriptor $this$overridesEqualsFromAny) {
        Intrinsics.checkNotNullParameter((Object)$this$overridesEqualsFromAny, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$overridesEqualsFromAny.getName(), (Object)OperatorNameConventions.EQUALS)) return false;
        if ($this$overridesEqualsFromAny.getValueParameters().size() != 1) return false;
        KotlinType kotlinType = $this$overridesEqualsFromAny.getValueParameters().get(0).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        if (!TypeUtilsKt.isNullableAny(kotlinType)) return false;
        if (!$this$overridesEqualsFromAny.getContextReceiverParameters().isEmpty()) return false;
        if ($this$overridesEqualsFromAny.getExtensionReceiverParameter() != null) return false;
        return true;
    }

    @NotNull
    public static final PackageFragmentDescriptor findPackage(@NotNull DeclarationDescriptor $this$findPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$findPackage, (String)"<this>");
        while (!($this$findPackage instanceof PackageFragmentDescriptor)) {
            Intrinsics.checkNotNull((Object)$this$findPackage.getContainingDeclaration());
        }
        return (PackageFragmentDescriptor)$this$findPackage;
    }
}

