/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.contracts.description;

import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.contracts.description.EventOccurrencesRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarkedEventOccurrencesRange<D> {
    private MarkedEventOccurrencesRange() {
    }

    @Nullable
    public D getLocation() {
        return null;
    }

    @NotNull
    public final EventOccurrencesRange getWithoutMarker() {
        EventOccurrencesRange eventOccurrencesRange;
        MarkedEventOccurrencesRange markedEventOccurrencesRange = this;
        if (Intrinsics.areEqual((Object)markedEventOccurrencesRange, (Object)Zero.INSTANCE)) {
            eventOccurrencesRange = EventOccurrencesRange.ZERO;
        } else if (markedEventOccurrencesRange instanceof AtMostOnce) {
            eventOccurrencesRange = EventOccurrencesRange.AT_MOST_ONCE;
        } else if (markedEventOccurrencesRange instanceof ExactlyOnce) {
            eventOccurrencesRange = EventOccurrencesRange.EXACTLY_ONCE;
        } else if (Intrinsics.areEqual((Object)markedEventOccurrencesRange, (Object)AtLeastOnce.INSTANCE)) {
            eventOccurrencesRange = EventOccurrencesRange.AT_LEAST_ONCE;
        } else if (Intrinsics.areEqual((Object)markedEventOccurrencesRange, (Object)MoreThanOnce.INSTANCE)) {
            eventOccurrencesRange = EventOccurrencesRange.MORE_THAN_ONCE;
        } else if (Intrinsics.areEqual((Object)markedEventOccurrencesRange, (Object)Unknown.INSTANCE)) {
            eventOccurrencesRange = EventOccurrencesRange.UNKNOWN;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return eventOccurrencesRange;
    }

    public /* synthetic */ MarkedEventOccurrencesRange(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class AtLeastOnce
    extends MarkedEventOccurrencesRange {
        @NotNull
        public static final AtLeastOnce INSTANCE = new AtLeastOnce();

        private AtLeastOnce() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "AtLeastOnce";
        }

        public int hashCode() {
            return 502740392;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AtLeastOnce)) {
                return false;
            }
            AtLeastOnce cfr_ignored_0 = (AtLeastOnce)other;
            return true;
        }
    }

    public static final class AtMostOnce<D>
    extends MarkedEventOccurrencesRange<D> {
        @NotNull
        private final D location;

        public AtMostOnce(@NotNull D location) {
            Intrinsics.checkNotNullParameter(location, (String)"location");
            super(null);
            this.location = location;
        }

        @Override
        @NotNull
        public D getLocation() {
            return this.location;
        }

        @NotNull
        public final D component1() {
            return this.location;
        }

        @NotNull
        public final AtMostOnce<D> copy(@NotNull D location) {
            Intrinsics.checkNotNullParameter(location, (String)"location");
            return new AtMostOnce<D>(location);
        }

        public static /* synthetic */ AtMostOnce copy$default(AtMostOnce atMostOnce, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = atMostOnce.location;
            }
            return atMostOnce.copy(object);
        }

        @NotNull
        public String toString() {
            return "AtMostOnce(location=" + this.location + ')';
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AtMostOnce)) {
                return false;
            }
            AtMostOnce atMostOnce = (AtMostOnce)other;
            return Intrinsics.areEqual(this.location, atMostOnce.location);
        }
    }

    public static final class ExactlyOnce<D>
    extends MarkedEventOccurrencesRange<D> {
        @NotNull
        private final D location;

        public ExactlyOnce(@NotNull D location) {
            Intrinsics.checkNotNullParameter(location, (String)"location");
            super(null);
            this.location = location;
        }

        @Override
        @NotNull
        public D getLocation() {
            return this.location;
        }

        @NotNull
        public final D component1() {
            return this.location;
        }

        @NotNull
        public final ExactlyOnce<D> copy(@NotNull D location) {
            Intrinsics.checkNotNullParameter(location, (String)"location");
            return new ExactlyOnce<D>(location);
        }

        public static /* synthetic */ ExactlyOnce copy$default(ExactlyOnce exactlyOnce, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = exactlyOnce.location;
            }
            return exactlyOnce.copy(object);
        }

        @NotNull
        public String toString() {
            return "ExactlyOnce(location=" + this.location + ')';
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExactlyOnce)) {
                return false;
            }
            ExactlyOnce exactlyOnce = (ExactlyOnce)other;
            return Intrinsics.areEqual(this.location, exactlyOnce.location);
        }
    }

    public static final class MoreThanOnce
    extends MarkedEventOccurrencesRange {
        @NotNull
        public static final MoreThanOnce INSTANCE = new MoreThanOnce();

        private MoreThanOnce() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "MoreThanOnce";
        }

        public int hashCode() {
            return -1399222202;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MoreThanOnce)) {
                return false;
            }
            MoreThanOnce cfr_ignored_0 = (MoreThanOnce)other;
            return true;
        }
    }

    public static final class Unknown
    extends MarkedEventOccurrencesRange {
        @NotNull
        public static final Unknown INSTANCE = new Unknown();

        private Unknown() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "Unknown";
        }

        public int hashCode() {
            return -282398501;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Unknown)) {
                return false;
            }
            Unknown cfr_ignored_0 = (Unknown)other;
            return true;
        }
    }

    public static final class Zero
    extends MarkedEventOccurrencesRange {
        @NotNull
        public static final Zero INSTANCE = new Zero();

        private Zero() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "Zero";
        }

        public int hashCode() {
            return 182938551;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Zero)) {
                return false;
            }
            Zero cfr_ignored_0 = (Zero)other;
            return true;
        }
    }
}

