/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.contracts.description;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtBooleanExpression;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtContractDescriptionVisitor;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtValueParameterReference;
import org.jetbrains.annotations.NotNull;

public class KtIsInstancePredicate<Type, Diagnostic>
implements KtBooleanExpression<Type, Diagnostic> {
    @NotNull
    private final KtValueParameterReference<Type, Diagnostic> arg;
    private final Type type;
    private final boolean isNegated;

    public KtIsInstancePredicate(@NotNull KtValueParameterReference<Type, Diagnostic> arg, Type type, boolean isNegated2) {
        Intrinsics.checkNotNullParameter(arg, (String)"arg");
        this.arg = arg;
        this.type = type;
        this.isNegated = isNegated2;
    }

    @NotNull
    public final KtValueParameterReference<Type, Diagnostic> getArg() {
        return this.arg;
    }

    public final Type getType() {
        return this.type;
    }

    public final boolean isNegated() {
        return this.isNegated;
    }

    @Override
    public boolean getErroneous() {
        return this.arg.getErroneous();
    }

    @Override
    public <R, D> R accept(@NotNull KtContractDescriptionVisitor<? extends R, ? super D, Type, Diagnostic> contractDescriptionVisitor, D data) {
        Intrinsics.checkNotNullParameter(contractDescriptionVisitor, (String)"contractDescriptionVisitor");
        return contractDescriptionVisitor.visitIsInstancePredicate(this, data);
    }

    @NotNull
    public final KtIsInstancePredicate<Type, Diagnostic> negated() {
        return new KtIsInstancePredicate<Type, Diagnostic>(this.arg, this.type, !this.isNegated);
    }
}

