/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.contracts.description;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtBooleanExpression;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtContractDescriptionVisitor;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtEffectDeclaration;
import org.jetbrains.annotations.NotNull;

public final class KtConditionalEffectDeclaration<Type, Diagnostic>
extends KtEffectDeclaration<Type, Diagnostic> {
    @NotNull
    private final KtEffectDeclaration<Type, Diagnostic> effect;
    @NotNull
    private final KtBooleanExpression<Type, Diagnostic> condition;

    public KtConditionalEffectDeclaration(@NotNull KtEffectDeclaration<Type, Diagnostic> effect, @NotNull KtBooleanExpression<Type, Diagnostic> condition) {
        Intrinsics.checkNotNullParameter(effect, (String)"effect");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        this.effect = effect;
        this.condition = condition;
    }

    @NotNull
    public final KtEffectDeclaration<Type, Diagnostic> getEffect() {
        return this.effect;
    }

    @NotNull
    public final KtBooleanExpression<Type, Diagnostic> getCondition() {
        return this.condition;
    }

    @Override
    public boolean getErroneous() {
        return this.effect.getErroneous() || this.condition.getErroneous();
    }

    @Override
    public <R, D> R accept(@NotNull KtContractDescriptionVisitor<? extends R, ? super D, Type, Diagnostic> contractDescriptionVisitor, D data) {
        Intrinsics.checkNotNullParameter(contractDescriptionVisitor, (String)"contractDescriptionVisitor");
        return contractDescriptionVisitor.visitConditionalEffectDeclaration(this, data);
    }
}

