/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.contracts.description;

import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.contracts.description.MarkedEventOccurrencesRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventOccurrencesRange
extends Enum<EventOccurrencesRange> {
    @NotNull
    public static final Companion Companion;
    private final int left;
    private final int right;
    public static final /* enum */ EventOccurrencesRange ZERO;
    public static final /* enum */ EventOccurrencesRange AT_MOST_ONCE;
    public static final /* enum */ EventOccurrencesRange EXACTLY_ONCE;
    public static final /* enum */ EventOccurrencesRange AT_LEAST_ONCE;
    public static final /* enum */ EventOccurrencesRange MORE_THAN_ONCE;
    public static final /* enum */ EventOccurrencesRange UNKNOWN;
    private static final /* synthetic */ EventOccurrencesRange[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private EventOccurrencesRange(int left, int right) {
        this.left = left;
        this.right = right;
    }

    @NotNull
    public final EventOccurrencesRange or(@NotNull EventOccurrencesRange other) {
        Intrinsics.checkNotNullParameter((Object)((Object)other), (String)"other");
        return Companion.or(this, other);
    }

    @NotNull
    public final EventOccurrencesRange plus(@NotNull EventOccurrencesRange other) {
        Intrinsics.checkNotNullParameter((Object)((Object)other), (String)"other");
        return Companion.plus(this, other);
    }

    public final boolean contains(@NotNull EventOccurrencesRange other) {
        Intrinsics.checkNotNullParameter((Object)((Object)other), (String)"other");
        return this.left <= other.left && other.right <= this.right;
    }

    @NotNull
    public final <D> MarkedEventOccurrencesRange<D> at(@Nullable D marker) {
        MarkedEventOccurrencesRange markedEventOccurrencesRange;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                markedEventOccurrencesRange = MarkedEventOccurrencesRange.Zero.INSTANCE;
                break;
            }
            case 2: {
                D d = marker;
                if (d == null) {
                    throw new AssertionError((Object)"AT_MOST_ONCE event requires location");
                }
                markedEventOccurrencesRange = new MarkedEventOccurrencesRange.AtMostOnce<D>(d);
                break;
            }
            case 3: {
                D d = marker;
                if (d == null) {
                    throw new AssertionError((Object)"EXACTLY_ONCE event requires location");
                }
                markedEventOccurrencesRange = new MarkedEventOccurrencesRange.ExactlyOnce<D>(d);
                break;
            }
            case 4: {
                markedEventOccurrencesRange = MarkedEventOccurrencesRange.AtLeastOnce.INSTANCE;
                break;
            }
            case 5: {
                markedEventOccurrencesRange = MarkedEventOccurrencesRange.MoreThanOnce.INSTANCE;
                break;
            }
            case 6: {
                markedEventOccurrencesRange = MarkedEventOccurrencesRange.Unknown.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return markedEventOccurrencesRange;
    }

    public static EventOccurrencesRange[] values() {
        return (EventOccurrencesRange[])$VALUES.clone();
    }

    public static EventOccurrencesRange valueOf(String value) {
        return Enum.valueOf(EventOccurrencesRange.class, value);
    }

    @NotNull
    public static EnumEntries<EventOccurrencesRange> getEntries() {
        return $ENTRIES;
    }

    static {
        ZERO = new EventOccurrencesRange(0, 0);
        AT_MOST_ONCE = new EventOccurrencesRange(0, 1);
        EXACTLY_ONCE = new EventOccurrencesRange(1, 1);
        AT_LEAST_ONCE = new EventOccurrencesRange(1, 3);
        MORE_THAN_ONCE = new EventOccurrencesRange(2, 3);
        UNKNOWN = new EventOccurrencesRange(0, 3);
        $VALUES = eventOccurrencesRangeArray = new EventOccurrencesRange[]{EventOccurrencesRange.ZERO, EventOccurrencesRange.AT_MOST_ONCE, EventOccurrencesRange.EXACTLY_ONCE, EventOccurrencesRange.AT_LEAST_ONCE, EventOccurrencesRange.MORE_THAN_ONCE, EventOccurrencesRange.UNKNOWN};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    public static final class Companion {
        private Companion() {
        }

        private final EventOccurrencesRange fromRange(int left, int right) {
            EventOccurrencesRange eventOccurrencesRange;
            Pair pair = TuplesKt.to((Object)Math.min(left, 2), (Object)Math.min(right, 3));
            if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)0, (Object)0))) {
                eventOccurrencesRange = ZERO;
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)0, (Object)1))) {
                eventOccurrencesRange = AT_MOST_ONCE;
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)0, (Object)2))) {
                eventOccurrencesRange = UNKNOWN;
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)0, (Object)3))) {
                eventOccurrencesRange = UNKNOWN;
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)1, (Object)1))) {
                eventOccurrencesRange = EXACTLY_ONCE;
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)1, (Object)2))) {
                eventOccurrencesRange = AT_LEAST_ONCE;
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)1, (Object)3))) {
                eventOccurrencesRange = AT_LEAST_ONCE;
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)2, (Object)2))) {
                eventOccurrencesRange = MORE_THAN_ONCE;
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)2, (Object)3))) {
                eventOccurrencesRange = MORE_THAN_ONCE;
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)3, (Object)3))) {
                eventOccurrencesRange = MORE_THAN_ONCE;
            } else {
                throw new IllegalArgumentException();
            }
            return eventOccurrencesRange;
        }

        @NotNull
        public final EventOccurrencesRange or(@NotNull EventOccurrencesRange x, @NotNull EventOccurrencesRange y) {
            Intrinsics.checkNotNullParameter((Object)((Object)x), (String)"x");
            Intrinsics.checkNotNullParameter((Object)((Object)y), (String)"y");
            return this.fromRange(Math.min(x.left, y.left), Math.max(x.right, y.right));
        }

        @NotNull
        public final EventOccurrencesRange plus(@NotNull EventOccurrencesRange x, @NotNull EventOccurrencesRange y) {
            Intrinsics.checkNotNullParameter((Object)((Object)x), (String)"x");
            Intrinsics.checkNotNullParameter((Object)((Object)y), (String)"y");
            return this.fromRange(x.left + y.left, x.right + y.right);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventOccurrencesRange.values().length];
            try {
                nArray[EventOccurrencesRange.ZERO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventOccurrencesRange.AT_MOST_ONCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventOccurrencesRange.EXACTLY_ONCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventOccurrencesRange.AT_LEAST_ONCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventOccurrencesRange.MORE_THAN_ONCE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventOccurrencesRange.UNKNOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

