/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.container;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.container.PlatformSpecificExtension;
import org.jetbrains.annotations.NotNull;

public abstract class PlatformExtensionsClashResolver<E extends PlatformSpecificExtension<E>> {
    @NotNull
    private final Class<E> applicableTo;

    public PlatformExtensionsClashResolver(@NotNull Class<E> applicableTo) {
        Intrinsics.checkNotNullParameter(applicableTo, (String)"applicableTo");
        this.applicableTo = applicableTo;
    }

    @NotNull
    public final Class<E> getApplicableTo() {
        return this.applicableTo;
    }

    @NotNull
    public abstract E resolveExtensionsClash(@NotNull List<? extends E> var1);

    public static final class FallbackToDefault<E extends PlatformSpecificExtension<E>>
    extends PlatformExtensionsClashResolver<E> {
        @NotNull
        private final E defaultValue;

        public FallbackToDefault(@NotNull E defaultValue, @NotNull Class<E> applicableTo) {
            Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
            Intrinsics.checkNotNullParameter(applicableTo, (String)"applicableTo");
            super(applicableTo);
            this.defaultValue = defaultValue;
        }

        @Override
        @NotNull
        public E resolveExtensionsClash(@NotNull List<? extends E> extensions) {
            Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
            return this.defaultValue;
        }
    }

    public static final class FirstWins<E extends PlatformSpecificExtension<E>>
    extends PlatformExtensionsClashResolver<E> {
        public FirstWins(@NotNull Class<E> applicableTo) {
            Intrinsics.checkNotNullParameter(applicableTo, (String)"applicableTo");
            super(applicableTo);
        }

        @Override
        @NotNull
        public E resolveExtensionsClash(@NotNull List<? extends E> extensions) {
            Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
            return (E)((PlatformSpecificExtension)CollectionsKt.first(extensions));
        }
    }
}

