/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.constant;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.constant.AnnotationArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.constant.ConstantValue;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KClassValue
extends ConstantValue<Value> {
    public KClassValue(@NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(value, null);
    }

    public KClassValue(@NotNull ClassLiteralValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this(new Value.NormalClass(value));
    }

    public KClassValue(@NotNull ClassId classId, int arrayDimensions) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        this(new ClassLiteralValue(classId, arrayDimensions));
    }

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visitKClassValue(this, data);
    }

    public static abstract class Value {
        private Value() {
        }

        public /* synthetic */ Value(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class LocalClass
        extends Value {
            @NotNull
            private final Object irClass;

            public LocalClass(@NotNull Object irClass) {
                Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
                super(null);
                this.irClass = irClass;
            }

            @NotNull
            public final Object getIrClass() {
                return this.irClass;
            }

            @NotNull
            public final Object component1() {
                return this.irClass;
            }

            @NotNull
            public final LocalClass copy(@NotNull Object irClass) {
                Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
                return new LocalClass(irClass);
            }

            public static /* synthetic */ LocalClass copy$default(LocalClass localClass, Object object, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = localClass.irClass;
                }
                return localClass.copy(object);
            }

            @NotNull
            public String toString() {
                return "LocalClass(irClass=" + this.irClass + ')';
            }

            public int hashCode() {
                return this.irClass.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LocalClass)) {
                    return false;
                }
                LocalClass localClass = (LocalClass)other;
                return Intrinsics.areEqual((Object)this.irClass, (Object)localClass.irClass);
            }
        }

        public static final class NormalClass
        extends Value {
            @NotNull
            private final ClassLiteralValue value;

            public NormalClass(@NotNull ClassLiteralValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(null);
                this.value = value;
            }

            @NotNull
            public final ClassLiteralValue getValue() {
                return this.value;
            }

            @NotNull
            public final ClassId getClassId() {
                return this.value.getClassId();
            }

            public final int getArrayDimensions() {
                return this.value.getArrayNestedness();
            }

            @NotNull
            public final ClassLiteralValue component1() {
                return this.value;
            }

            @NotNull
            public final NormalClass copy(@NotNull ClassLiteralValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new NormalClass(value);
            }

            public static /* synthetic */ NormalClass copy$default(NormalClass normalClass, ClassLiteralValue classLiteralValue, int n, Object object) {
                if ((n & 1) != 0) {
                    classLiteralValue = normalClass.value;
                }
                return normalClass.copy(classLiteralValue);
            }

            @NotNull
            public String toString() {
                return "NormalClass(value=" + this.value + ')';
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NormalClass)) {
                    return false;
                }
                NormalClass normalClass = (NormalClass)other;
                return Intrinsics.areEqual((Object)this.value, (Object)normalClass.value);
            }
        }
    }
}

