/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.constant;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.constant.AnnotationArgumentVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConstantValue<T> {
    private final T value;

    private ConstantValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public abstract <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> var1, D var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        ConstantValue constantValue = other instanceof ConstantValue ? (ConstantValue)other : null;
        if (!Intrinsics.areEqual(this.getValue(), constantValue != null ? constantValue.getValue() : null)) return false;
        return true;
    }

    public int hashCode() {
        T t = this.getValue();
        return t != null ? t.hashCode() : 0;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.getValue());
    }

    @NotNull
    public String stringTemplateValue() {
        return String.valueOf(this.getValue());
    }

    public /* synthetic */ ConstantValue(Object value, DefaultConstructorMarker $constructor_marker) {
        this(value);
    }
}

