/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.constant;

import java.util.Map;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.constant.AnnotationArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.constant.ConstantValue;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;

public final class AnnotationValue
extends ConstantValue<Value> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private AnnotationValue(Value value) {
        super(value, null);
    }

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visitAnnotationValue(this, data);
    }

    public /* synthetic */ AnnotationValue(Value value, DefaultConstructorMarker $constructor_marker) {
        this(value);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnnotationValue create(@NotNull ClassId classId, @NotNull Map<Name, ? extends ConstantValue<?>> argumentsMapping) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            Intrinsics.checkNotNullParameter(argumentsMapping, (String)"argumentsMapping");
            return new AnnotationValue(new Value(classId, argumentsMapping), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Value {
        @NotNull
        private final ClassId classId;
        @NotNull
        private final Map<Name, ConstantValue<?>> argumentsMapping;

        public Value(@NotNull ClassId classId, @NotNull Map<Name, ? extends ConstantValue<?>> argumentsMapping) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            Intrinsics.checkNotNullParameter(argumentsMapping, (String)"argumentsMapping");
            this.classId = classId;
            this.argumentsMapping = argumentsMapping;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @NotNull
        public final Map<Name, ConstantValue<?>> getArgumentsMapping() {
            return this.argumentsMapping;
        }

        @NotNull
        public String toString() {
            return "Value(classId=" + this.classId + ", argumentsMapping=" + this.argumentsMapping + ')';
        }
    }
}

