/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PlatformToKotlinClassMapper;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nJavaToKotlinClassMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaToKotlinClassMapper.kt\norg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMapper\n*L\n1#1,80:1\n75#1,3:81\n75#1,3:84\n*S KotlinDebug\n*F\n+ 1 JavaToKotlinClassMapper.kt\norg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMapper\n*L\n59#1:81,3\n65#1:84,3\n*E\n"})
public final class JavaToKotlinClassMapper
implements PlatformToKotlinClassMapper {
    @NotNull
    public static final JavaToKotlinClassMapper INSTANCE = new JavaToKotlinClassMapper();

    private JavaToKotlinClassMapper() {
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(classDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"getFqName(...)");
        FqNameUnsafe className = fqNameUnsafe;
        return className.isSafe() ? this.mapPlatformClass(className.toSafe(), DescriptorUtilsKt.getBuiltIns(classDescriptor)) : (Collection<ClassDescriptor>)SetsKt.emptySet();
    }

    @NotNull
    public final Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        ClassDescriptor classDescriptor = JavaToKotlinClassMapper.mapJavaToKotlin$default(this, fqName, builtIns, null, 4, null);
        if (classDescriptor == null) {
            return SetsKt.emptySet();
        }
        ClassDescriptor kotlinAnalog = classDescriptor;
        FqName fqName2 = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable(DescriptorUtilsKt.getFqNameUnsafe(kotlinAnalog));
        if (fqName2 == null) {
            return SetsKt.setOf((Object)kotlinAnalog);
        }
        FqName kotlinMutableAnalogFqName = fqName2;
        Object[] objectArray = new ClassDescriptor[]{kotlinAnalog, builtIns.getBuiltInClassByFqName(kotlinMutableAnalogFqName)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public final ClassDescriptor mapJavaToKotlin(@NotNull FqName fqName, @NotNull KotlinBuiltIns builtIns, @Nullable Integer functionTypeArity) {
        ClassId kotlinClassId;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        ClassId classId = kotlinClassId = functionTypeArity != null && Intrinsics.areEqual((Object)fqName, (Object)JavaToKotlinClassMap.INSTANCE.getFUNCTION_N_FQ_NAME()) ? StandardNames.getFunctionClassId(functionTypeArity) : JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName);
        return classId != null ? builtIns.getBuiltInClassByFqName(classId.asSingleFqName()) : null;
    }

    public static /* synthetic */ ClassDescriptor mapJavaToKotlin$default(JavaToKotlinClassMapper javaToKotlinClassMapper, FqName fqName, KotlinBuiltIns kotlinBuiltIns, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return javaToKotlinClassMapper.mapJavaToKotlin(fqName, kotlinBuiltIns, n);
    }

    public final boolean isMutable(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkNotNullParameter((Object)mutable, (String)"mutable");
        return JavaToKotlinClassMap.INSTANCE.isMutable(DescriptorUtils.getFqName(mutable));
    }

    public final boolean isMutable(@NotNull KotlinType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type);
        return classDescriptor != null && this.isMutable(classDescriptor);
    }

    public final boolean isReadOnly(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkNotNullParameter((Object)readOnly, (String)"readOnly");
        return JavaToKotlinClassMap.INSTANCE.isReadOnly(DescriptorUtils.getFqName(readOnly));
    }

    public final boolean isReadOnly(@NotNull KotlinType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type);
        return classDescriptor != null && this.isReadOnly(classDescriptor);
    }

    @NotNull
    public final ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkNotNullParameter((Object)mutable, (String)"mutable");
        JavaToKotlinClassMapper javaToKotlinClassMapper = this;
        String mutabilityKindName$iv = "mutable";
        boolean $i$f$convertToOppositeMutability = false;
        FqNameUnsafe it = DescriptorUtils.getFqName(mutable);
        boolean bl = false;
        FqName fqName = JavaToKotlinClassMap.INSTANCE.mutableToReadOnly(it);
        if (fqName == null) {
            throw new IllegalArgumentException("Given class " + mutable + " is not a " + mutabilityKindName$iv + " collection");
        }
        FqName oppositeClassFqName$iv = fqName;
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getBuiltIns(mutable).getBuiltInClassByFqName(oppositeClassFqName$iv);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getBuiltInClassByFqName(...)");
        return classDescriptor;
    }

    @NotNull
    public final ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkNotNullParameter((Object)readOnly, (String)"readOnly");
        JavaToKotlinClassMapper javaToKotlinClassMapper = this;
        String mutabilityKindName$iv = "read-only";
        boolean $i$f$convertToOppositeMutability = false;
        FqNameUnsafe it = DescriptorUtils.getFqName(readOnly);
        boolean bl = false;
        FqName fqName = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable(it);
        if (fqName == null) {
            throw new IllegalArgumentException("Given class " + readOnly + " is not a " + mutabilityKindName$iv + " collection");
        }
        FqName oppositeClassFqName$iv = fqName;
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getBuiltIns(readOnly).getBuiltInClassByFqName(oppositeClassFqName$iv);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getBuiltInClassByFqName(...)");
        return classDescriptor;
    }

    private final ClassDescriptor convertToOppositeMutability(ClassDescriptor descriptor2, String mutabilityKindName, Function1<? super FqNameUnsafe, FqName> oppositeNameExtractor) {
        boolean $i$f$convertToOppositeMutability = false;
        FqName fqName = (FqName)oppositeNameExtractor.invoke((Object)DescriptorUtils.getFqName(descriptor2));
        if (fqName == null) {
            throw new IllegalArgumentException("Given class " + descriptor2 + " is not a " + mutabilityKindName + " collection");
        }
        FqName oppositeClassFqName = fqName;
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getBuiltIns(descriptor2).getBuiltInClassByFqName(oppositeClassFqName);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getBuiltInClassByFqName(...)");
        return classDescriptor;
    }
}

