/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.StandardClassIds;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nReflectionTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectionTypes.kt\norg/jetbrains/kotlin/builtins/ReflectionTypes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,225:1\n1563#2:226\n1634#2,3:227\n*S KotlinDebug\n*F\n+ 1 ReflectionTypes.kt\norg/jetbrains/kotlin/builtins/ReflectionTypes\n*L\n94#1:226\n94#1:227,3\n*E\n"})
public final class ReflectionTypes {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final NotFoundClasses notFoundClasses;
    @NotNull
    private final Lazy kotlinReflectScope$delegate;
    @NotNull
    private final ClassLookup kClass$delegate;
    @NotNull
    private final ClassLookup kProperty$delegate;
    @NotNull
    private final ClassLookup kProperty0$delegate;
    @NotNull
    private final ClassLookup kProperty1$delegate;
    @NotNull
    private final ClassLookup kProperty2$delegate;
    @NotNull
    private final ClassLookup kMutableProperty0$delegate;
    @NotNull
    private final ClassLookup kMutableProperty1$delegate;
    @NotNull
    private final ClassLookup kMutableProperty2$delegate;

    public ReflectionTypes(@NotNull ModuleDescriptor module, @NotNull NotFoundClasses notFoundClasses) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)notFoundClasses, (String)"notFoundClasses");
        this.notFoundClasses = notFoundClasses;
        this.kotlinReflectScope$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> ReflectionTypes.kotlinReflectScope_delegate$lambda$0(module));
        this.kClass$delegate = new ClassLookup(1);
        this.kProperty$delegate = new ClassLookup(1);
        this.kProperty0$delegate = new ClassLookup(1);
        this.kProperty1$delegate = new ClassLookup(2);
        this.kProperty2$delegate = new ClassLookup(3);
        this.kMutableProperty0$delegate = new ClassLookup(1);
        this.kMutableProperty1$delegate = new ClassLookup(2);
        this.kMutableProperty2$delegate = new ClassLookup(3);
    }

    private final MemberScope getKotlinReflectScope() {
        Lazy lazy = this.kotlinReflectScope$delegate;
        return (MemberScope)lazy.getValue();
    }

    private final ClassDescriptor find(String className, int numberOfTypeParameters) {
        Name name = Name.identifier(className);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        Name name2 = name;
        ClassifierDescriptor classifierDescriptor = this.getKotlinReflectScope().getContributedClassifier(name2, NoLookupLocation.FROM_REFLECTION);
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            classDescriptor = this.notFoundClasses.getClass(new ClassId(StandardNames.KOTLIN_REFLECT_FQ_NAME, name2), CollectionsKt.listOf((Object)numberOfTypeParameters));
        }
        return classDescriptor;
    }

    @NotNull
    public final ClassDescriptor getKFunction(int n) {
        return this.find("KFunction" + n, n + 1);
    }

    @NotNull
    public final ClassDescriptor getKSuspendFunction(int n) {
        return this.find("KSuspendFunction" + n, n + 1);
    }

    @NotNull
    public final ClassDescriptor getKClass() {
        return this.kClass$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @NotNull
    public final ClassDescriptor getKProperty() {
        return this.kProperty$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @NotNull
    public final ClassDescriptor getKProperty0() {
        return this.kProperty0$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @NotNull
    public final ClassDescriptor getKProperty1() {
        return this.kProperty1$delegate.getValue(this, $$delegatedProperties[3]);
    }

    @NotNull
    public final ClassDescriptor getKProperty2() {
        return this.kProperty2$delegate.getValue(this, $$delegatedProperties[4]);
    }

    @NotNull
    public final ClassDescriptor getKMutableProperty0() {
        return this.kMutableProperty0$delegate.getValue(this, $$delegatedProperties[5]);
    }

    @NotNull
    public final ClassDescriptor getKMutableProperty1() {
        return this.kMutableProperty1$delegate.getValue(this, $$delegatedProperties[6]);
    }

    @NotNull
    public final ClassDescriptor getKMutableProperty2() {
        return this.kMutableProperty2$delegate.getValue(this, $$delegatedProperties[7]);
    }

    @NotNull
    public final KotlinType getKClassType(@NotNull Annotations annotations, @NotNull KotlinType type, @NotNull Variance variance) {
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)variance), (String)"variance");
        return KotlinTypeFactory.simpleNotNullType(TypeAttributesKt.toDefaultAttributes(annotations), this.getKClass(), CollectionsKt.listOf((Object)new TypeProjectionImpl(variance, type)));
    }

    @NotNull
    public final SimpleType getKFunctionType(@NotNull Annotations annotations, @Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> contextReceiverTypes, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType, @NotNull KotlinBuiltIns builtIns, boolean isSuspend) {
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(contextReceiverTypes, (String)"contextReceiverTypes");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        List<TypeProjection> arguments = FunctionTypesKt.getFunctionTypeArgumentProjections(receiverType, contextReceiverTypes, parameterTypes, parameterNames, returnType, builtIns);
        ClassDescriptor classDescriptor = isSuspend ? this.getKSuspendFunction(arguments.size() - 1) : this.getKFunction(arguments.size() - 1);
        return KotlinTypeFactory.simpleNotNullType(TypeAttributesKt.toDefaultAttributes(annotations), classDescriptor, arguments);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimpleType getKPropertyType(@NotNull Annotations annotations, @NotNull List<? extends KotlinType> receiverTypes, @NotNull KotlinType returnType, boolean mutable) {
        void $this$mapTo$iv$iv;
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(receiverTypes, (String)"receiverTypes");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        switch (receiverTypes.size()) {
            case 0: {
                if (mutable) {
                    classDescriptor = this.getKMutableProperty0();
                    break;
                }
                classDescriptor = this.getKProperty0();
                break;
            }
            case 1: {
                if (mutable) {
                    classDescriptor = this.getKMutableProperty1();
                    break;
                }
                classDescriptor = this.getKProperty1();
                break;
            }
            case 2: {
                if (mutable) {
                    classDescriptor = this.getKMutableProperty2();
                    break;
                }
                classDescriptor = this.getKProperty2();
                break;
            }
            default: {
                throw new AssertionError((Object)"More than 2 receivers is not allowed");
            }
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        Iterable $this$map$iv = CollectionsKt.plus((Collection)receiverTypes, (Object)returnType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TypeProjectionImpl((KotlinType)p0));
        }
        List arguments = (List)destination$iv$iv;
        return KotlinTypeFactory.simpleNotNullType(TypeAttributesKt.toDefaultAttributes(annotations), classDescriptor2, arguments);
    }

    private static final MemberScope kotlinReflectScope_delegate$lambda$0(ModuleDescriptor $module) {
        return $module.getPackage(StandardNames.KOTLIN_REFLECT_FQ_NAME).getMemberScope();
    }

    @JvmStatic
    public static final boolean isNumberedKPropertyOrKMutablePropertyType(@NotNull KotlinType type) {
        return Companion.isNumberedKPropertyOrKMutablePropertyType(type);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ReflectionTypes.class, "kClass", "getKClass()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ReflectionTypes.class, "kProperty", "getKProperty()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ReflectionTypes.class, "kProperty0", "getKProperty0()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ReflectionTypes.class, "kProperty1", "getKProperty1()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ReflectionTypes.class, "kProperty2", "getKProperty2()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ReflectionTypes.class, "kMutableProperty0", "getKMutableProperty0()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ReflectionTypes.class, "kMutableProperty1", "getKMutableProperty1()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ReflectionTypes.class, "kMutableProperty2", "getKMutableProperty2()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    private static final class ClassLookup {
        private final int numberOfTypeParameters;

        public ClassLookup(int numberOfTypeParameters) {
            this.numberOfTypeParameters = numberOfTypeParameters;
        }

        public final int getNumberOfTypeParameters() {
            return this.numberOfTypeParameters;
        }

        @NotNull
        public final ClassDescriptor getValue(@NotNull ReflectionTypes types, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter((Object)types, (String)"types");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            return types.find(CapitalizeDecapitalizeKt.capitalizeAsciiOnly(property.getName()), this.numberOfTypeParameters);
        }
    }

    @SourceDebugExtension(value={"SMAP\nReflectionTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectionTypes.kt\norg/jetbrains/kotlin/builtins/ReflectionTypes$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,225:1\n1761#2,3:226\n*S KotlinDebug\n*F\n+ 1 ReflectionTypes.kt\norg/jetbrains/kotlin/builtins/ReflectionTypes$Companion\n*L\n122#1:226,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isReflectionClass(@NotNull ClassDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PackageFragmentDescriptor containingPackage = DescriptorUtils.getParentOfType(descriptor2, PackageFragmentDescriptor.class);
            return containingPackage != null && Intrinsics.areEqual((Object)containingPackage.getFqName(), (Object)StandardNames.KOTLIN_REFLECT_FQ_NAME);
        }

        public final boolean isKClassType(@NotNull KotlinType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            ClassifierDescriptor classifierDescriptor = type.unwrap().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                return false;
            }
            ClassifierDescriptor descriptor2 = classifierDescriptor;
            return Intrinsics.areEqual((Object)DescriptorUtilsKt.getClassId(descriptor2), (Object)StandardClassIds.INSTANCE.getKClass());
        }

        public final boolean isCallableType(@NotNull KotlinType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return FunctionTypesKt.isFunctionTypeOrSubtype(type) || FunctionTypesKt.isSuspendFunctionTypeOrSubtype(type) || this.isKCallableType(type);
        }

        public final boolean isBaseTypeForNumberedReferenceTypes(@NotNull KotlinType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return Companion.hasKPropertyTypeFqName(type) || Companion.hasKMutablePropertyTypeFqName(type) || Companion.hasKCallableTypeFqName(type);
        }

        @JvmStatic
        public final boolean isNumberedKPropertyOrKMutablePropertyType(@NotNull KotlinType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this.isNumberedKPropertyType(type) || this.isNumberedKMutablePropertyType(type);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isKCallableType(@NotNull KotlinType type) {
            KotlinType it;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            if (this.hasKCallableTypeFqName(type)) return true;
            Collection<KotlinType> collection = type.getConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getSupertypes(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (KotlinType)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
            } while (!Companion.isKCallableType(it));
            return true;
        }

        public final boolean hasKCallableTypeFqName(@NotNull KotlinType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this.hasFqName(type.getConstructor(), StandardNames.FqNames.kCallable);
        }

        public final boolean hasKMutablePropertyTypeFqName(@NotNull KotlinType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this.hasFqName(type.getConstructor(), StandardNames.FqNames.kMutablePropertyFqName);
        }

        public final boolean isNumberedKMutablePropertyType(@NotNull KotlinType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor == null) {
                return false;
            }
            ClassDescriptor descriptor2 = classDescriptor;
            return this.hasFqName(descriptor2, StandardNames.FqNames.kMutableProperty0) || this.hasFqName(descriptor2, StandardNames.FqNames.kMutableProperty1) || this.hasFqName(descriptor2, StandardNames.FqNames.kMutableProperty2);
        }

        public final boolean isNumberedTypeWithOneOrMoreNumber(@NotNull KotlinType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor == null) {
                return false;
            }
            ClassDescriptor descriptor2 = classDescriptor;
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(descriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"getFqName(...)");
            FqNameUnsafe fqName = fqNameUnsafe;
            if (fqName.isRoot()) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)fqName.parent().toSafe(), (Object)StandardNames.KOTLIN_REFLECT_FQ_NAME)) {
                return false;
            }
            String string = descriptor2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String shortName = string;
            for (String prefix : StandardNames.PREFIXES) {
                if (!StringsKt.startsWith$default((String)shortName, (String)prefix, (boolean)false, (int)2, null)) continue;
                String number = StringsKt.removePrefix((String)shortName, (CharSequence)prefix);
                return ((CharSequence)number).length() > 0 && !Intrinsics.areEqual((Object)number, (Object)"0");
            }
            return false;
        }

        public final boolean hasKPropertyTypeFqName(@NotNull KotlinType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this.hasFqName(type.getConstructor(), StandardNames.FqNames.kPropertyFqName);
        }

        public final boolean isNumberedKPropertyType(@NotNull KotlinType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor == null) {
                return false;
            }
            ClassDescriptor descriptor2 = classDescriptor;
            return this.hasFqName(descriptor2, StandardNames.FqNames.kProperty0) || this.hasFqName(descriptor2, StandardNames.FqNames.kProperty1) || this.hasFqName(descriptor2, StandardNames.FqNames.kProperty2);
        }

        public final boolean isNumberedKFunctionOrKSuspendFunction(@NotNull KotlinType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this.isNumberedKFunction(type) || this.isNumberedKSuspendFunction(type);
        }

        public final boolean isNumberedKFunction(@NotNull KotlinType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor == null) {
                return false;
            }
            ClassDescriptor descriptor2 = classDescriptor;
            String string = descriptor2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String shortName = string;
            return shortName.length() > 9 && StringsKt.startsWith$default((String)shortName, (String)"KFunction", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)DescriptorUtils.getFqName(descriptor2).parent().toSafe(), (Object)StandardNames.KOTLIN_REFLECT_FQ_NAME);
        }

        public final boolean isNumberedKSuspendFunction(@NotNull KotlinType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor == null) {
                return false;
            }
            ClassDescriptor descriptor2 = classDescriptor;
            String string = descriptor2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String shortName = string;
            return shortName.length() > 16 && StringsKt.startsWith$default((String)shortName, (String)"KSuspendFunction", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)DescriptorUtils.getFqName(descriptor2).parent().toSafe(), (Object)StandardNames.KOTLIN_REFLECT_FQ_NAME);
        }

        private final boolean hasFqName(TypeConstructor typeConstructor2, FqNameUnsafe fqName) {
            ClassifierDescriptor descriptor2 = typeConstructor2.getDeclarationDescriptor();
            return descriptor2 instanceof ClassDescriptor && this.hasFqName((ClassDescriptor)descriptor2, fqName);
        }

        private final boolean hasFqName(ClassDescriptor descriptor2, FqNameUnsafe fqName) {
            return Intrinsics.areEqual((Object)descriptor2.getName(), (Object)fqName.shortName()) && Intrinsics.areEqual((Object)DescriptorUtils.getFqName(descriptor2), (Object)fqName);
        }

        @Nullable
        public final KotlinType createKPropertyStarType(@NotNull ModuleDescriptor module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(module, StandardNames.FqNames.kProperty);
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor kPropertyClass = classDescriptor;
            TypeAttributes typeAttributes = TypeAttributes.Companion.getEmpty();
            List<TypeParameterDescriptor> list = kPropertyClass.getTypeConstructor().getParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
            Object object = CollectionsKt.single(list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"single(...)");
            return KotlinTypeFactory.simpleNotNullType(typeAttributes, kPropertyClass, CollectionsKt.listOf((Object)new StarProjectionImpl((TypeParameterDescriptor)object)));
        }

        public final boolean isPossibleExpectedCallableType(@NotNull TypeConstructor typeConstructor2) {
            Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"typeConstructor");
            ClassifierDescriptor classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
            ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor == null) {
                return false;
            }
            ClassDescriptor descriptor2 = classDescriptor;
            if (KotlinBuiltIns.isAny(descriptor2)) {
                return true;
            }
            String string = descriptor2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String shortName = string;
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(descriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"getFqName(...)");
            FqNameUnsafe fqName = fqNameUnsafe;
            if (fqName.isRoot()) {
                return false;
            }
            FqName packageName = fqName.parent().toSafe();
            if (Intrinsics.areEqual((Object)packageName, (Object)StandardNames.KOTLIN_REFLECT_FQ_NAME)) {
                return StringsKt.startsWith$default((String)shortName, (String)"KFunction", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)shortName, (String)"KSuspendFunction", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)shortName, (String)"KProperty", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)shortName, (String)"KMutableProperty", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)shortName, (Object)"KCallable") || Intrinsics.areEqual((Object)shortName, (Object)"KAnnotatedElement");
            }
            if (Intrinsics.areEqual((Object)packageName, (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME) || Intrinsics.areEqual((Object)packageName, (Object)StandardNames.COROUTINES_PACKAGE_FQ_NAME)) {
                return StringsKt.startsWith$default((String)shortName, (String)"Function", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)shortName, (String)"SuspendFunction", (boolean)false, (int)2, null);
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

