/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PrimitiveType
extends Enum<PrimitiveType> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Name typeName;
    @NotNull
    private final Name arrayTypeName;
    @NotNull
    private final Lazy typeFqName$delegate;
    @NotNull
    private final Lazy arrayTypeFqName$delegate;
    @JvmField
    @NotNull
    public static final Set<PrimitiveType> NUMBER_TYPES;
    public static final /* enum */ PrimitiveType BOOLEAN;
    public static final /* enum */ PrimitiveType CHAR;
    public static final /* enum */ PrimitiveType BYTE;
    public static final /* enum */ PrimitiveType SHORT;
    public static final /* enum */ PrimitiveType INT;
    public static final /* enum */ PrimitiveType FLOAT;
    public static final /* enum */ PrimitiveType LONG;
    public static final /* enum */ PrimitiveType DOUBLE;
    private static final /* synthetic */ PrimitiveType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private PrimitiveType(String typeName) {
        Name name = Name.identifier(typeName);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        this.typeName = name;
        Name name2 = Name.identifier(typeName + "Array");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        this.arrayTypeName = name2;
        this.typeFqName$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> PrimitiveType.typeFqName_delegate$lambda$0(this));
        this.arrayTypeFqName$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> PrimitiveType.arrayTypeFqName_delegate$lambda$1(this));
    }

    @NotNull
    public final Name getTypeName() {
        return this.typeName;
    }

    @NotNull
    public final Name getArrayTypeName() {
        return this.arrayTypeName;
    }

    @NotNull
    public final FqName getTypeFqName() {
        Lazy lazy = this.typeFqName$delegate;
        return (FqName)lazy.getValue();
    }

    @NotNull
    public final FqName getArrayTypeFqName() {
        Lazy lazy = this.arrayTypeFqName$delegate;
        return (FqName)lazy.getValue();
    }

    public static PrimitiveType[] values() {
        return (PrimitiveType[])$VALUES.clone();
    }

    public static PrimitiveType valueOf(String value) {
        return Enum.valueOf(PrimitiveType.class, value);
    }

    @NotNull
    public static EnumEntries<PrimitiveType> getEntries() {
        return $ENTRIES;
    }

    private static final FqName typeFqName_delegate$lambda$0(PrimitiveType this$0) {
        return StandardNames.BUILT_INS_PACKAGE_FQ_NAME.child(this$0.typeName);
    }

    private static final FqName arrayTypeFqName_delegate$lambda$1(PrimitiveType this$0) {
        return StandardNames.BUILT_INS_PACKAGE_FQ_NAME.child(this$0.arrayTypeName);
    }

    @JvmStatic
    @Nullable
    public static final PrimitiveType getByShortName(@NotNull String name) {
        return Companion.getByShortName(name);
    }

    @JvmStatic
    @Nullable
    public static final PrimitiveType getByShortArrayName(@NotNull String name) {
        return Companion.getByShortArrayName(name);
    }

    static {
        BOOLEAN = new PrimitiveType("Boolean");
        CHAR = new PrimitiveType("Char");
        BYTE = new PrimitiveType("Byte");
        SHORT = new PrimitiveType("Short");
        INT = new PrimitiveType("Int");
        FLOAT = new PrimitiveType("Float");
        LONG = new PrimitiveType("Long");
        DOUBLE = new PrimitiveType("Double");
        $VALUES = primitiveTypeArray = new PrimitiveType[]{PrimitiveType.BOOLEAN, PrimitiveType.CHAR, PrimitiveType.BYTE, PrimitiveType.SHORT, PrimitiveType.INT, PrimitiveType.FLOAT, PrimitiveType.LONG, PrimitiveType.DOUBLE};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        PrimitiveType[] primitiveTypeArray = new PrimitiveType[]{CHAR, BYTE, SHORT, INT, FLOAT, LONG, DOUBLE};
        NUMBER_TYPES = SetsKt.setOf((Object[])primitiveTypeArray);
    }

    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final PrimitiveType getByShortName(@NotNull String name) {
            PrimitiveType primitiveType;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            switch (name) {
                case "Boolean": {
                    primitiveType = BOOLEAN;
                    break;
                }
                case "Char": {
                    primitiveType = CHAR;
                    break;
                }
                case "Byte": {
                    primitiveType = BYTE;
                    break;
                }
                case "Short": {
                    primitiveType = SHORT;
                    break;
                }
                case "Int": {
                    primitiveType = INT;
                    break;
                }
                case "Float": {
                    primitiveType = FLOAT;
                    break;
                }
                case "Long": {
                    primitiveType = LONG;
                    break;
                }
                case "Double": {
                    primitiveType = DOUBLE;
                    break;
                }
                default: {
                    primitiveType = null;
                }
            }
            return primitiveType;
        }

        /*
         * WARNING - bad return control flow
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @Nullable
        public final PrimitiveType getByShortArrayName(@NotNull String name) {
            PrimitiveType primitiveType;
            block21: {
                block16: {
                    block17: {
                        block18: {
                            block20: {
                                block19: {
                                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                                    String string = name;
                                    switch (string.hashCode()) {
                                        case 2104330525: {
                                            if (!string.equals("LongArray")) {
                                                return null;
                                            }
                                            break block16;
                                        }
                                        case -755911549: {
                                            if (string.equals("CharArray")) break;
                                            return null;
                                        }
                                        case 948852093: {
                                            if (!string.equals("FloatArray")) {
                                                return null;
                                            }
                                            break block17;
                                        }
                                        case 601811914: {
                                            if (!string.equals("IntArray")) {
                                                return null;
                                            }
                                            break block18;
                                        }
                                        case -74930671: {
                                            if (!string.equals("ByteArray")) {
                                                return null;
                                            }
                                            break block19;
                                        }
                                        case -763279523: {
                                            if (!string.equals("ShortArray")) {
                                                return null;
                                            }
                                            break block20;
                                        }
                                        case 22374632: {
                                            if (!string.equals("DoubleArray")) {
                                                return null;
                                            }
                                            break block21;
                                        }
                                        case -901856463: {
                                            if (!string.equals("BooleanArray")) return null;
                                            primitiveType = BOOLEAN;
                                            return primitiveType;
                                        }
                                    }
                                    primitiveType = CHAR;
                                    return primitiveType;
                                }
                                primitiveType = BYTE;
                                return primitiveType;
                            }
                            primitiveType = SHORT;
                            return primitiveType;
                        }
                        primitiveType = INT;
                        return primitiveType;
                    }
                    primitiveType = FLOAT;
                    return primitiveType;
                }
                primitiveType = LONG;
                return primitiveType;
            }
            primitiveType = DOUBLE;
            return primitiveType;
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

