/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.transport.file;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.AbstractTransporter;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.GetTask;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.PeekTask;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.PutTask;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.TransportTask;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.NoTransporterException;
import org.jetbrains.kotlin.org.eclipse.aether.transport.file.PathUtils;
import org.jetbrains.kotlin.org.eclipse.aether.transport.file.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FileTransporter
extends AbstractTransporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTransporter.class);
    private final File basedir;

    FileTransporter(RemoteRepository repository) throws NoTransporterException {
        if (!"file".equalsIgnoreCase(repository.getProtocol())) {
            throw new NoTransporterException(repository);
        }
        this.basedir = new File(PathUtils.basedir(repository.getUrl())).getAbsoluteFile();
    }

    File getBasedir() {
        return this.basedir;
    }

    @Override
    public int classify(Throwable error) {
        if (error instanceof ResourceNotFoundException) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void implPeek(PeekTask task) throws Exception {
        this.getFile(task, true);
    }

    @Override
    protected void implGet(GetTask task) throws Exception {
        File file = this.getFile(task, true);
        this.utilGet(task, Files.newInputStream(file.toPath(), new OpenOption[0]), true, file.length(), false);
    }

    @Override
    protected void implPut(PutTask task) throws Exception {
        File file = this.getFile(task, false);
        file.getParentFile().mkdirs();
        try {
            this.utilPut(task, Files.newOutputStream(file.toPath(), new OpenOption[0]), true);
        }
        catch (Exception e) {
            if (!file.delete() && file.exists()) {
                LOGGER.debug("Could not delete partial file {}", (Object)file);
            }
            throw e;
        }
    }

    private File getFile(TransportTask task, boolean required) throws Exception {
        String path = task.getLocation().getPath();
        if (path.contains("../")) {
            throw new IllegalArgumentException("illegal resource path: " + path);
        }
        File file = new File(this.basedir, path);
        if (required && !file.exists()) {
            throw new ResourceNotFoundException("Could not locate " + file);
        }
        return file;
    }

    @Override
    protected void implClose() {
    }
}

