/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.resolution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.repository.ArtifactRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalArtifactResult;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactRequest;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.ArtifactNotFoundException;

public final class ArtifactResult {
    private final ArtifactRequest request;
    private List<Exception> exceptions;
    private Artifact artifact;
    private ArtifactRepository repository;
    private LocalArtifactResult localArtifactResult;

    public ArtifactResult(ArtifactRequest request) {
        this.request = Objects.requireNonNull(request, "artifact request cannot be null");
        this.exceptions = Collections.emptyList();
    }

    public ArtifactRequest getRequest() {
        return this.request;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactResult setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public ArtifactResult addException(Exception exception) {
        if (exception != null) {
            if (this.exceptions.isEmpty()) {
                this.exceptions = new ArrayList<Exception>();
            }
            this.exceptions.add(exception);
        }
        return this;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public ArtifactResult setRepository(ArtifactRepository repository) {
        this.repository = repository;
        return this;
    }

    public LocalArtifactResult getLocalArtifactResult() {
        return this.localArtifactResult;
    }

    public void setLocalArtifactResult(LocalArtifactResult localArtifactResult) {
        this.localArtifactResult = localArtifactResult;
    }

    public boolean isResolved() {
        return this.getArtifact() != null && this.getArtifact().getFile() != null;
    }

    public boolean isMissing() {
        for (Exception e : this.getExceptions()) {
            if (e instanceof ArtifactNotFoundException) continue;
            return false;
        }
        return !this.isResolved();
    }

    public String toString() {
        return this.getArtifact() + " < " + this.getRepository();
    }
}

