/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.named.support;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.LockUpgradeNotSupportedException;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.NamedLockSupport;

public class ReadWriteLockNamedLock
extends NamedLockSupport {
    private final ThreadLocal<Deque<Step>> threadSteps = ThreadLocal.withInitial(ArrayDeque::new);
    private final ReadWriteLock readWriteLock;

    public ReadWriteLockNamedLock(String name, NamedLockFactorySupport factory, ReadWriteLock readWriteLock) {
        super(name, factory);
        this.readWriteLock = readWriteLock;
    }

    @Override
    protected boolean doLockShared(long time, TimeUnit unit) throws InterruptedException {
        Deque<Step> steps = this.threadSteps.get();
        if (this.readWriteLock.readLock().tryLock(time, unit)) {
            steps.push(Step.SHARED);
            return true;
        }
        return false;
    }

    @Override
    protected boolean doLockExclusively(long time, TimeUnit unit) throws InterruptedException {
        Deque<Step> steps = this.threadSteps.get();
        if (!steps.isEmpty() && !steps.contains((Object)Step.EXCLUSIVE)) {
            throw new LockUpgradeNotSupportedException(this);
        }
        if (this.readWriteLock.writeLock().tryLock(time, unit)) {
            steps.push(Step.EXCLUSIVE);
            return true;
        }
        return false;
    }

    @Override
    protected void doUnlock() {
        Deque<Step> steps = this.threadSteps.get();
        if (steps.isEmpty()) {
            throw new IllegalStateException("Wrong API usage: unlock without lock");
        }
        Step step = steps.pop();
        if (Step.SHARED == step) {
            this.readWriteLock.readLock().unlock();
        } else if (Step.EXCLUSIVE == step) {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private static enum Step {
        SHARED,
        EXCLUSIVE;

    }
}

