/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.SyncContext;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.named.NamedLock;
import org.jetbrains.kotlin.org.eclipse.aether.named.NamedLockFactory;
import org.jetbrains.kotlin.org.eclipse.aether.named.providers.FileLockNamedLockFactory;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamedLockFactoryAdapter {
    public static final String TIME_KEY = "aether.syncContext.named.time";
    public static final long DEFAULT_TIME = 30L;
    public static final String TIME_UNIT_KEY = "aether.syncContext.named.time.unit";
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    public static final String RETRY_KEY = "aether.syncContext.named.retry";
    public static final int DEFAULT_RETRY = 1;
    public static final String RETRY_WAIT_KEY = "aether.syncContext.named.retry.wait";
    public static final long DEFAULT_RETRY_WAIT = 200L;
    private final NameMapper nameMapper;
    private final NamedLockFactory namedLockFactory;

    public NamedLockFactoryAdapter(NameMapper nameMapper, NamedLockFactory namedLockFactory) {
        this.nameMapper = Objects.requireNonNull(nameMapper);
        this.namedLockFactory = Objects.requireNonNull(namedLockFactory);
        if (this.namedLockFactory instanceof FileLockNamedLockFactory && !this.nameMapper.isFileSystemFriendly()) {
            throw new IllegalArgumentException("Misconfiguration: FileLockNamedLockFactory lock factory requires FS friendly NameMapper");
        }
    }

    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        return new AdaptedLockSyncContext(session, shared, this.nameMapper, this.namedLockFactory);
    }

    public NameMapper getNameMapper() {
        return this.nameMapper;
    }

    public NamedLockFactory getNamedLockFactory() {
        return this.namedLockFactory;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(nameMapper=" + this.nameMapper + ", namedLockFactory=" + this.namedLockFactory + ")";
    }

    private static class AdaptedLockSyncContext
    implements SyncContext {
        private static final Logger LOGGER = LoggerFactory.getLogger(AdaptedLockSyncContext.class);
        private final RepositorySystemSession session;
        private final boolean shared;
        private final NameMapper lockNaming;
        private final NamedLockFactory namedLockFactory;
        private final long time;
        private final TimeUnit timeUnit;
        private final int retry;
        private final long retryWait;
        private final Deque<NamedLock> locks;

        private AdaptedLockSyncContext(RepositorySystemSession session, boolean shared, NameMapper lockNaming, NamedLockFactory namedLockFactory) {
            this.session = session;
            this.shared = shared;
            this.lockNaming = lockNaming;
            this.namedLockFactory = namedLockFactory;
            this.time = this.getTime(session);
            this.timeUnit = this.getTimeUnit(session);
            this.retry = this.getRetry(session);
            this.retryWait = this.getRetryWait(session);
            this.locks = new ArrayDeque<NamedLock>();
            if (this.time < 0L) {
                throw new IllegalArgumentException("aether.syncContext.named.time value cannot be negative");
            }
            if ((long)this.retry < 0L) {
                throw new IllegalArgumentException("aether.syncContext.named.retry value cannot be negative");
            }
            if (this.retryWait < 0L) {
                throw new IllegalArgumentException("aether.syncContext.named.retry.wait value cannot be negative");
            }
        }

        private long getTime(RepositorySystemSession session) {
            return ConfigUtils.getLong(session, 30L, NamedLockFactoryAdapter.TIME_KEY);
        }

        private TimeUnit getTimeUnit(RepositorySystemSession session) {
            return TimeUnit.valueOf(ConfigUtils.getString(session, DEFAULT_TIME_UNIT.name(), NamedLockFactoryAdapter.TIME_UNIT_KEY));
        }

        private int getRetry(RepositorySystemSession session) {
            return ConfigUtils.getInteger(session, 1, NamedLockFactoryAdapter.RETRY_KEY);
        }

        private long getRetryWait(RepositorySystemSession session) {
            return ConfigUtils.getLong(session, 200L, NamedLockFactoryAdapter.RETRY_WAIT_KEY);
        }

        @Override
        public void acquire(Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
            Collection<String> keys = this.lockNaming.nameLocks(this.session, artifacts, metadatas);
            if (keys.isEmpty()) {
                return;
            }
            int attempts = this.retry + 1;
            ArrayList<IllegalStateException> illegalStateExceptions = new ArrayList<IllegalStateException>();
            for (int attempt = 1; attempt <= attempts; ++attempt) {
                LOGGER.trace("Attempt {}: Need {} {} lock(s) for {}", attempt, keys.size(), this.shared ? "read" : "write", keys);
                int acquiredLockCount = 0;
                try {
                    if (attempt > 1) {
                        Thread.sleep(this.retryWait);
                    }
                    for (String key : keys) {
                        NamedLock namedLock = this.namedLockFactory.getLock(key);
                        LOGGER.trace("Acquiring {} lock for '{}'", (Object)(this.shared ? "read" : "write"), (Object)key);
                        boolean locked = this.shared ? namedLock.lockShared(this.time, this.timeUnit) : namedLock.lockExclusively(this.time, this.timeUnit);
                        if (!locked) {
                            String timeStr = this.time + " " + (Object)((Object)this.timeUnit);
                            LOGGER.trace("Failed to acquire {} lock for '{}' in {}", this.shared ? "read" : "write", key, timeStr);
                            namedLock.close();
                            this.closeAll();
                            illegalStateExceptions.add(new IllegalStateException("Attempt " + attempt + ": Could not acquire " + (this.shared ? "read" : "write") + " lock for '" + namedLock.name() + "' in " + timeStr));
                            break;
                        }
                        this.locks.push(namedLock);
                        ++acquiredLockCount;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                LOGGER.trace("Attempt {}: Total locks acquired: {}", (Object)attempt, (Object)acquiredLockCount);
                if (acquiredLockCount == keys.size()) break;
            }
            if (!illegalStateExceptions.isEmpty()) {
                IllegalStateException ex = new IllegalStateException("Could not acquire lock(s)");
                illegalStateExceptions.forEach(ex::addSuppressed);
                throw this.namedLockFactory.onFailure(ex);
            }
        }

        private void closeAll() {
            if (this.locks.isEmpty()) {
                return;
            }
            int released = 0;
            while (!this.locks.isEmpty()) {
                NamedLock namedLock = this.locks.pop();
                try {
                    LOGGER.trace("Releasing {} lock for '{}'", (Object)(this.shared ? "read" : "write"), (Object)namedLock.name());
                    namedLock.unlock();
                    ++released;
                }
                finally {
                    if (namedLock == null) continue;
                    namedLock.close();
                }
            }
            LOGGER.trace("Total locks released: {}", (Object)released);
        }

        @Override
        public void close() {
            this.closeAll();
        }
    }
}

