/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named;

import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.BasedirNameMapper;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.DiscriminatingNameMapper;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.GAVNameMapper;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.HashingNameMapper;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.StaticNameMapper;

public final class NameMappers {
    public static final String STATIC_NAME = "static";
    public static final String GAV_NAME = "gav";
    public static final String FILE_GAV_NAME = "file-gav";
    public static final String FILE_HGAV_NAME = "file-hgav";
    public static final String FILE_STATIC_NAME = "file-static";
    public static final String DISCRIMINATING_NAME = "discriminating";

    public static NameMapper staticNameMapper() {
        return new StaticNameMapper();
    }

    public static NameMapper gavNameMapper() {
        return GAVNameMapper.gav();
    }

    public static NameMapper fileGavNameMapper() {
        return new BasedirNameMapper(GAVNameMapper.fileGav());
    }

    public static NameMapper fileStaticNameMapper() {
        return new BasedirNameMapper(new StaticNameMapper());
    }

    public static NameMapper fileHashingGavNameMapper() {
        return new BasedirNameMapper(new HashingNameMapper(GAVNameMapper.gav()));
    }

    public static NameMapper discriminatingNameMapper() {
        return new DiscriminatingNameMapper(GAVNameMapper.gav());
    }
}

