/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.resolution;

import java.util.List;
import java.util.Objects;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactResult;
import org.jetbrains.kotlin.org.eclipse.aether.spi.resolution.ArtifactResolverPostProcessor;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;

public abstract class ArtifactResolverPostProcessorSupport
implements ArtifactResolverPostProcessor {
    private static final String CONFIG_PROP_PREFIX = "aether.artifactResolver.postProcessor.";
    private final String name;

    protected ArtifactResolverPostProcessorSupport(String name) {
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public void postProcess(RepositorySystemSession session, List<ArtifactResult> artifactResults) {
        if (this.isEnabled(session)) {
            this.doPostProcess(session, artifactResults);
        }
    }

    protected abstract void doPostProcess(RepositorySystemSession var1, List<ArtifactResult> var2);

    protected String configPropKey(String name) {
        Objects.requireNonNull(name);
        return CONFIG_PROP_PREFIX + this.name + "." + name;
    }

    protected boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, CONFIG_PROP_PREFIX + this.name);
    }
}

