/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.logging;

import java.util.Map;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.AbstractLoggerManager;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.Logger;
import org.jetbrains.kotlin.org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Weak;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.Roles;

public abstract class BaseLoggerManager
extends AbstractLoggerManager
implements Initializable {
    private final Map<String, Logger> activeLoggers = Weak.values();
    String threshold = "INFO";
    private int currentThreshold;

    @Override
    public final void initialize() {
        this.currentThreshold = BaseLoggerManager.parseThreshold(this.threshold);
    }

    @Override
    public final synchronized Logger getLoggerForComponent(String role, String hint) {
        String name = Roles.canonicalRoleHint(role, hint);
        Logger logger = this.activeLoggers.get(name);
        if (null == logger) {
            logger = this.createLogger(name);
            logger.setThreshold(this.currentThreshold);
            this.activeLoggers.put(name, logger);
        }
        return logger;
    }

    @Override
    public final synchronized void returnComponentLogger(String role, String hint) {
        this.activeLoggers.remove(Roles.canonicalRoleHint(role, hint));
    }

    @Override
    public final int getThreshold() {
        return this.currentThreshold;
    }

    @Override
    public final void setThreshold(int currentThreshold) {
        this.currentThreshold = currentThreshold;
    }

    @Override
    public final synchronized void setThresholds(int currentThreshold) {
        this.currentThreshold = currentThreshold;
        for (Logger logger : this.activeLoggers.values()) {
            logger.setThreshold(currentThreshold);
        }
    }

    public static final int parseThreshold(String text) {
        if ("DEBUG".equalsIgnoreCase(text)) {
            return 0;
        }
        if ("INFO".equalsIgnoreCase(text)) {
            return 1;
        }
        if ("WARN".equalsIgnoreCase(text)) {
            return 2;
        }
        if ("ERROR".equalsIgnoreCase(text)) {
            return 3;
        }
        if ("FATAL".equalsIgnoreCase(text)) {
            return 4;
        }
        if ("DISABLED".equalsIgnoreCase(text)) {
            return 5;
        }
        return 0;
    }

    @Override
    public final synchronized int getActiveLoggerCount() {
        return this.activeLoggers.size();
    }

    protected abstract Logger createLogger(String var1);
}

