/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.lookup;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.BooleanConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.ByteConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.CharConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.DateConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.DoubleConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.EnumConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.FileConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.FloatConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.IntConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.LongConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.PathConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.ShortConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.StringBufferConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.StringBuilderConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.StringConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.TemporalConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.UriConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.basic.UrlConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.composite.ArrayConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.composite.CollectionConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.composite.MapConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.composite.PlexusConfigurationConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.composite.PropertiesConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.special.ClassRealmConverter;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Weak;

public final class DefaultConverterLookup
implements ConverterLookup {
    private static final ConfigurationConverter[] DEFAULT_CONVERTERS = new ConfigurationConverter[]{new FileConverter(), new BooleanConverter(), new StringConverter(), new IntConverter(), new CollectionConverter(), new ArrayConverter(), new MapConverter(), new PropertiesConverter(), new UrlConverter(), new UriConverter(), new PathConverter(), new DateConverter(), new EnumConverter(), new LongConverter(), new FloatConverter(), new DoubleConverter(), new CharConverter(), new ByteConverter(), new ShortConverter(), new PlexusConfigurationConverter(), new ClassRealmConverter(), new StringBufferConverter(), new StringBuilderConverter(), new TemporalConverter(), new ObjectWithFieldsConverter()};
    private final Map<Class<?>, ConfigurationConverter> lookupCache = Weak.concurrentKeys();
    private final List<ConfigurationConverter> customConverters = new CopyOnWriteArrayList<ConfigurationConverter>();

    @Override
    public void registerConverter(ConfigurationConverter converter) {
        this.customConverters.add(converter);
    }

    @Override
    public ConfigurationConverter lookupConverterForType(Class<?> type) throws ComponentConfigurationException {
        int i;
        ConfigurationConverter converter = this.lookupCache.get(type);
        if (null != converter) {
            return converter;
        }
        for (i = 0; i < this.customConverters.size(); ++i) {
            converter = this.customConverters.get(i);
            if (!converter.canConvert(type)) continue;
            this.lookupCache.put(type, converter);
            return converter;
        }
        for (i = 0; i < DEFAULT_CONVERTERS.length; ++i) {
            converter = DEFAULT_CONVERTERS[i];
            if (!converter.canConvert(type)) continue;
            this.lookupCache.put(type, converter);
            return converter;
        }
        throw new ComponentConfigurationException("Cannot find converter for type: " + type);
    }

    void setCustomConverters(List<ConfigurationConverter> converters) {
        this.customConverters.addAll(converters);
    }
}

